/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.value.datetimejoda;

import com.google.common.collect.Maps;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.isis.applib.profiles.Localization;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.value.vsp.ValueSemanticsProviderAndFacetAbstract;
import org.apache.isis.core.metamodel.facets.object.value.vsp.ValueSemanticsProviderContext;
import org.apache.isis.core.metamodel.facets.value.ValueSemanticsProviderAbstractTemporal;

public abstract class JodaDateTimeValueSemanticsProviderAbstract<T>
extends ValueSemanticsProviderAbstractTemporal<T> {
    private static final Map<String, DateFormat> FORMATS = Maps.newHashMap();

    public JodaDateTimeValueSemanticsProviderAbstract(FacetHolder holder, Class<T> adaptedClass, T defaultValue, IsisConfiguration configuration, ValueSemanticsProviderContext context) {
        super("date", holder, adaptedClass, 12, ValueSemanticsProviderAndFacetAbstract.Immutability.IMMUTABLE, ValueSemanticsProviderAndFacetAbstract.EqualByContent.HONOURED, defaultValue, configuration, context);
        String formatRequired = configuration.getString("isis.value.format.date");
        if (formatRequired == null) {
            this.format = this.formats().get(this.defaultFormat());
        } else {
            this.setMask(formatRequired);
        }
    }

    @Override
    protected void clearFields(Calendar cal) {
        cal.set(10, 0);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(9, 0);
        cal.set(14, 0);
    }

    @Override
    protected String defaultFormat() {
        return "medium";
    }

    @Override
    protected boolean ignoreTimeZone() {
        return true;
    }

    @Override
    protected Map<String, DateFormat> formats() {
        return FORMATS;
    }

    @Override
    public String toString() {
        return "DateValueSemanticsProvider: " + this.format;
    }

    @Override
    protected DateFormat format(Localization localization) {
        DateFormat dateFormat = DateFormat.getDateInstance(2, localization.getLocale());
        dateFormat.setTimeZone(UTC_TIME_ZONE);
        return dateFormat;
    }

    @Override
    protected List<DateFormat> formatsToTry(Localization localization) {
        ArrayList<DateFormat> formats = new ArrayList<DateFormat>();
        Locale locale = localization == null ? Locale.getDefault() : localization.getLocale();
        formats.add(DateFormat.getDateInstance(1, locale));
        formats.add(DateFormat.getDateInstance(2, locale));
        formats.add(DateFormat.getDateInstance(3, locale));
        formats.add(JodaDateTimeValueSemanticsProviderAbstract.createDateFormat("yyyy-MM-dd"));
        formats.add(JodaDateTimeValueSemanticsProviderAbstract.createDateFormat("yyyyMMdd"));
        for (DateFormat format : formats) {
            format.setTimeZone(UTC_TIME_ZONE);
        }
        return formats;
    }

    static {
        FORMATS.put("iso_encoding", JodaDateTimeValueSemanticsProviderAbstract.createDateEncodingFormat("yyyyMMdd"));
        FORMATS.put("iso", JodaDateTimeValueSemanticsProviderAbstract.createDateFormat("yyyy-MM-dd"));
        FORMATS.put("medium", DateFormat.getDateInstance(2));
    }
}

