/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.value.time;

import com.google.common.collect.Maps;
import java.text.DateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.isis.applib.value.Time;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.value.vsp.ValueSemanticsProviderContext;
import org.apache.isis.core.metamodel.facets.value.time.TimeValueSemanticsProviderAbstract;

public class TimeValueSemanticsProvider
extends TimeValueSemanticsProviderAbstract<Time> {
    private static final Map<String, DateFormat> formats = Maps.newHashMap();

    public TimeValueSemanticsProvider() {
        this((FacetHolder)null, (IsisConfiguration)null, (ValueSemanticsProviderContext)null);
    }

    public TimeValueSemanticsProvider(FacetHolder holder, IsisConfiguration configuration, ValueSemanticsProviderContext context) {
        super(holder, Time.class, configuration, context);
    }

    @Override
    protected Map<String, DateFormat> formats() {
        return formats;
    }

    @Override
    protected boolean ignoreTimeZone() {
        return true;
    }

    @Override
    protected Time add(Time original, int years, int months, int days, int hours, int minutes) {
        Time time = original;
        time = time.add(hours, minutes);
        return time;
    }

    @Override
    protected Date dateValue(Object object) {
        Time time = (Time)object;
        return time == null ? null : time.asJavaDate();
    }

    @Override
    protected Time now() {
        return new Time();
    }

    @Override
    protected Time setDate(Date date) {
        return new Time(date.getTime());
    }

    static {
        TimeValueSemanticsProvider.initFormats(formats);
    }
}

