/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.value.timestamp;

import com.google.common.collect.Maps;
import java.text.DateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.isis.applib.value.TimeStamp;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.parseable.InvalidEntryException;
import org.apache.isis.core.metamodel.facets.object.value.vsp.ValueSemanticsProviderContext;
import org.apache.isis.core.metamodel.facets.properties.defaults.PropertyDefaultFacet;
import org.apache.isis.core.metamodel.facets.value.timestamp.TimeStampValueSemanticsProviderAbstract;

public class TimeStampValueSemanticsProvider
extends TimeStampValueSemanticsProviderAbstract<TimeStamp> {
    private static Map<String, DateFormat> formats = Maps.newHashMap();

    public static final boolean isAPropertyDefaultFacet() {
        return PropertyDefaultFacet.class.isAssignableFrom(TimeStampValueSemanticsProvider.class);
    }

    public TimeStampValueSemanticsProvider() {
        this((FacetHolder)null, (IsisConfiguration)null, (ValueSemanticsProviderContext)null);
    }

    public TimeStampValueSemanticsProvider(FacetHolder holder, IsisConfiguration configuration, ValueSemanticsProviderContext context) {
        super(holder, TimeStamp.class, configuration, context);
    }

    @Override
    protected Date dateValue(Object value) {
        return new Date(((TimeStamp)value).longValue());
    }

    @Override
    protected Map<String, DateFormat> formats() {
        return formats;
    }

    @Override
    protected TimeStamp now() {
        throw new InvalidEntryException("Can't change a timestamp.");
    }

    @Override
    protected TimeStamp setDate(Date date) {
        return new TimeStamp(date.getTime());
    }

    static {
        TimeStampValueSemanticsProvider.initFormats(formats);
    }
}

