/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.interactions;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.events.InteractionEvent;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.InteractionContextType;
import org.apache.isis.core.metamodel.consent.InteractionInvocationMethod;
import org.apache.isis.core.metamodel.deployment.DeploymentCategory;

public abstract class InteractionContext<T extends InteractionEvent> {
    private final InteractionContextType interactionType;
    private final Identifier identifier;
    private final InteractionInvocationMethod invocation;
    private final AuthenticationSession session;
    private final ObjectAdapter target;
    private final DeploymentCategory deploymentCategory;
    private int contributeeParam = -1;
    private ObjectAdapter contributee = null;

    public InteractionContext(InteractionContextType interactionType, DeploymentCategory deploymentCategory, AuthenticationSession session, InteractionInvocationMethod invocationMethod, Identifier identifier, ObjectAdapter target) {
        this.interactionType = interactionType;
        this.invocation = invocationMethod;
        this.identifier = identifier;
        this.session = session;
        this.target = target;
        this.deploymentCategory = deploymentCategory;
    }

    public DeploymentCategory getDeploymentCategory() {
        return this.deploymentCategory;
    }

    public InteractionContextType getInteractionType() {
        return this.interactionType;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public AuthenticationSession getSession() {
        return this.session;
    }

    public InteractionInvocationMethod getInvocationMethod() {
        return this.invocation;
    }

    public boolean isProgrammatic() {
        return this.invocation == InteractionInvocationMethod.PROGRAMMATIC;
    }

    public ObjectAdapter getTarget() {
        return this.target;
    }

    public void putContributee(int contributeeParam, ObjectAdapter contributee) {
        this.contributeeParam = contributeeParam;
        this.contributee = contributee;
    }

    public Map<Integer, ObjectAdapter> getContributeeAsMap() {
        return this.contributee != null ? ImmutableMap.of((Object)this.contributeeParam, (Object)this.contributee) : ImmutableMap.of();
    }

    public abstract T createInteractionEvent();
}

