/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.progmodel;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.factory.InstanceUtil;
import org.apache.isis.core.metamodel.facetapi.MetaModelValidatorRefiner;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.progmodel.ProgrammingModel;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;

public abstract class ProgrammingModelAbstract
implements ProgrammingModel {
    private final List<FacetFactory> facetFactories = Lists.newArrayList();
    private final List<Object> facetFactoryInstancesOrClasses = Lists.newArrayList();

    @Override
    public void init() {
        this.initializeIfRequired();
    }

    private void initializeIfRequired() {
        if (!this.facetFactories.isEmpty()) {
            return;
        }
        this.initialize();
    }

    private void initialize() {
        for (Object factoryInstanceOrClass : this.facetFactoryInstancesOrClasses) {
            FacetFactory facetFactory = ProgrammingModelAbstract.asFacetFactory(factoryInstanceOrClass);
            this.facetFactories.add(facetFactory);
        }
    }

    private static FacetFactory asFacetFactory(Object factoryInstanceOrClass) {
        if (factoryInstanceOrClass instanceof FacetFactory) {
            return (FacetFactory)factoryInstanceOrClass;
        }
        Class factoryClass = (Class)factoryInstanceOrClass;
        return (FacetFactory)InstanceUtil.createInstance(factoryClass);
    }

    private void assertNotInitialized() {
        if (!this.facetFactories.isEmpty()) {
            throw new IllegalStateException("Programming model already initialized");
        }
    }

    @Override
    public final List<FacetFactory> getList() {
        this.initializeIfRequired();
        return Collections.unmodifiableList(this.facetFactories);
    }

    @Override
    public final void addFactory(Class<? extends FacetFactory> factoryClass) {
        this.addFactory(factoryClass, ProgrammingModel.Position.END);
    }

    @Override
    public final void addFactory(Class<? extends FacetFactory> factoryClass, ProgrammingModel.Position position) {
        this.addFactory((Object)factoryClass, position);
    }

    @Override
    public void addFactory(FacetFactory facetFactory) {
        this.addFactory(facetFactory, ProgrammingModel.Position.END);
    }

    @Override
    public void addFactory(FacetFactory facetFactory, ProgrammingModel.Position position) {
        this.addFactory((Object)facetFactory, position);
    }

    private void addFactory(Object facetFactoryInstanceOrClass, ProgrammingModel.Position position) {
        this.assertNotInitialized();
        switch (position) {
            case BEGINNING: {
                this.facetFactoryInstancesOrClasses.add(0, facetFactoryInstanceOrClass);
                break;
            }
            case END: {
                this.facetFactoryInstancesOrClasses.add(facetFactoryInstanceOrClass);
            }
        }
    }

    @Override
    public final void removeFactory(Class<? extends FacetFactory> factoryClass) {
        this.assertNotInitialized();
        this.facetFactoryInstancesOrClasses.remove(factoryClass);
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator, IsisConfiguration configuration) {
        for (FacetFactory facetFactory : this.getList()) {
            if (!(facetFactory instanceof MetaModelValidatorRefiner)) continue;
            MetaModelValidatorRefiner metaModelValidatorRefiner = (MetaModelValidatorRefiner)((Object)facetFactory);
            metaModelValidatorRefiner.refineMetaModelValidator(metaModelValidator, configuration);
        }
    }
}

