/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.runtimecontext;

import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.isis.core.metamodel.runtimecontext.RuntimeContext;
import org.apache.isis.core.metamodel.runtimecontext.RuntimeContextAware;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjectorAware;
import org.apache.isis.core.metamodel.services.ServicesInjectorSpi;
import org.apache.isis.core.metamodel.services.ServicesInjectorSpiDelegator;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationLoader;
import org.apache.isis.core.metamodel.spec.SpecificationLoaderDelegator;
import org.apache.isis.core.metamodel.spec.SpecificationLoaderSpi;
import org.apache.isis.core.metamodel.spec.SpecificationLoaderSpiAware;

public abstract class RuntimeContextAbstract
implements RuntimeContext,
SpecificationLoaderSpiAware,
ServicesInjectorAware {
    private final SpecificationLoaderDelegator specificationLookupDelegator = new SpecificationLoaderDelegator();
    protected final ServicesInjectorSpiDelegator servicesInjectorDelegator = new ServicesInjectorSpiDelegator();
    private Properties properties;

    @Override
    public void init() {
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void injectInto(Object candidate) {
        if (RuntimeContextAware.class.isAssignableFrom(candidate.getClass())) {
            RuntimeContextAware cast = (RuntimeContextAware)RuntimeContextAware.class.cast(candidate);
            cast.setRuntimeContext(this);
        }
        this.injectSubcomponentsInto(candidate);
    }

    protected void injectSubcomponentsInto(Object candidate) {
        this.getAdapterManager().injectInto(candidate);
        this.getAuthenticationSessionProvider().injectInto(candidate);
        this.getServicesInjector().injectInto(candidate);
        this.getDomainObjectServices().injectInto(candidate);
        this.getLocalizationProvider().injectInto(candidate);
        this.getObjectInstantiator().injectInto(candidate);
        this.getObjectDirtier().injectInto(candidate);
        this.getObjectPersistor().injectInto(candidate);
        this.getQuerySubmitter().injectInto(candidate);
        this.getServicesProvider().injectInto(candidate);
        this.getSpecificationLoader().injectInto(candidate);
    }

    @Override
    public SpecificationLoader getSpecificationLoader() {
        return this.specificationLookupDelegator;
    }

    @Override
    public void setSpecificationLoaderSpi(final SpecificationLoaderSpi specificationLoader) {
        this.specificationLookupDelegator.setDelegate(new SpecificationLoader(){

            @Override
            public void injectInto(Object candidate) {
                specificationLoader.injectInto(candidate);
            }

            @Override
            public ObjectSpecification loadSpecification(Class<?> cls) {
                return specificationLoader.loadSpecification(cls);
            }

            @Override
            public Collection<ObjectSpecification> allSpecifications() {
                return specificationLoader.allSpecifications();
            }

            @Override
            public ObjectSpecification lookupBySpecId(ObjectSpecId objectSpecId) {
                return specificationLoader.lookupBySpecId(objectSpecId);
            }

            @Override
            public ObjectSpecification loadSpecification(String fullyQualifiedClassName) {
                return specificationLoader.loadSpecification(fullyQualifiedClassName);
            }

            @Override
            public boolean loadSpecifications(List<Class<?>> typesToLoad) {
                return specificationLoader.loadSpecifications(typesToLoad);
            }

            @Override
            public boolean loadSpecifications(List<Class<?>> typesToLoad, Class<?> typeToIgnore) {
                return specificationLoader.loadSpecifications(typesToLoad, typeToIgnore);
            }

            @Override
            public boolean loaded(Class<?> cls) {
                return specificationLoader.loaded(cls);
            }

            @Override
            public boolean loaded(String fullyQualifiedClassName) {
                return specificationLoader.loaded(fullyQualifiedClassName);
            }

            @Override
            public ObjectSpecification introspectIfRequired(ObjectSpecification spec) {
                return specificationLoader.introspectIfRequired(spec);
            }

            @Override
            public List<Class<?>> getServiceClasses() {
                return specificationLoader.getServiceClasses();
            }

            @Override
            public boolean isServiceClass(Class<?> cls) {
                return specificationLoader.isServiceClass(cls);
            }

            @Override
            public void invalidateCache(Class<?> domainClass) {
                specificationLoader.invalidateCache(domainClass);
            }

            @Override
            public boolean isInjectorMethodFor(Method method, Class<? extends Object> serviceClass) {
                return specificationLoader.isInjectorMethodFor(method, serviceClass);
            }
        });
    }

    protected void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    public List<String> getPropertyNames() {
        ArrayList list = Lists.newArrayList();
        for (Object key : this.properties.keySet()) {
            list.add((String)key);
        }
        return list;
    }

    @Override
    public void setServicesInjector(ServicesInjector servicesInjector) {
        this.servicesInjectorDelegator.setServicesInjectorSpi((ServicesInjectorSpi)servicesInjector);
    }
}

