/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services.container;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.isis.applib.DomainObjectContainer;
import org.apache.isis.applib.PersistFailedException;
import org.apache.isis.applib.RecoverableException;
import org.apache.isis.applib.RepositoryException;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.filter.Filter;
import org.apache.isis.applib.filter.Filters;
import org.apache.isis.applib.query.Query;
import org.apache.isis.applib.query.QueryFindAllInstances;
import org.apache.isis.applib.security.RoleMemento;
import org.apache.isis.applib.security.UserMemento;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizer;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizer2;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizerComposite;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizerForType;
import org.apache.isis.applib.services.i18n.TranslatableString;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.apache.isis.applib.services.wrapper.WrapperFactory;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProvider;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProviderAware;
import org.apache.isis.core.commons.ensure.Assert;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.metamodel.adapter.DomainObjectServices;
import org.apache.isis.core.metamodel.adapter.DomainObjectServicesAware;
import org.apache.isis.core.metamodel.adapter.LocalizationProvider;
import org.apache.isis.core.metamodel.adapter.LocalizationProviderAware;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ObjectDirtier;
import org.apache.isis.core.metamodel.adapter.ObjectDirtierAware;
import org.apache.isis.core.metamodel.adapter.ObjectPersistor;
import org.apache.isis.core.metamodel.adapter.ObjectPersistorAware;
import org.apache.isis.core.metamodel.adapter.QuerySubmitter;
import org.apache.isis.core.metamodel.adapter.QuerySubmitterAware;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManagerAware;
import org.apache.isis.core.metamodel.adapter.oid.AggregatedOid;
import org.apache.isis.core.metamodel.adapter.version.ConcurrencyException;
import org.apache.isis.core.metamodel.consent.InteractionResult;
import org.apache.isis.core.metamodel.facets.object.viewmodel.ViewModelFacet;
import org.apache.isis.core.metamodel.services.container.query.QueryFindByPattern;
import org.apache.isis.core.metamodel.services.container.query.QueryFindByTitle;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationLoader;
import org.apache.isis.core.metamodel.spec.SpecificationLoaderAware;

@DomainService(nature=NatureOfService.DOMAIN)
public class DomainObjectContainerDefault
implements DomainObjectContainer,
QuerySubmitterAware,
ObjectDirtierAware,
DomainObjectServicesAware,
ObjectPersistorAware,
SpecificationLoaderAware,
AuthenticationSessionProviderAware,
AdapterManagerAware,
LocalizationProviderAware,
ExceptionRecognizer {
    private final ThreadLocal<Stack<UserAndRoleOverrides>> overrides = new ThreadLocal<Stack<UserAndRoleOverrides>>(){

        @Override
        protected Stack<UserAndRoleOverrides> initialValue() {
            return new Stack<UserAndRoleOverrides>();
        }
    };
    private final ExceptionRecognizer recognizer = new ExceptionRecognizerComposite(new ExceptionRecognizer[]{new ExceptionRecognizerForConcurrencyException(), new ExceptionRecognizerForRecoverableException()});
    private static final String KEY_DISABLE_AUTOFLUSH = "isis.services.container.disableAutoFlush";
    private boolean autoFlush;
    private ObjectDirtier objectDirtier;
    private ObjectPersistor objectPersistor;
    private QuerySubmitter querySubmitter;
    private SpecificationLoader specificationLoader;
    private DomainObjectServices domainObjectServices;
    private AuthenticationSessionProvider authenticationSessionProvider;
    private AdapterManager adapterManager;
    private LocalizationProvider localizationProvider;
    @Inject
    WrapperFactory wrapperFactory;
    @Inject
    TranslationService translationService;

    @Programmatic
    public String titleOf(Object domainObject) {
        ObjectAdapter objectAdapter = this.adapterManager.adapterFor(this.unwrapped(domainObject));
        boolean destroyed = objectAdapter.isDestroyed();
        if (!destroyed) {
            return objectAdapter.getSpecification().getTitle(objectAdapter, this.localizationProvider.getLocalization());
        }
        return "[DELETED]";
    }

    @Programmatic
    public <T> T newTransientInstance(Class<T> ofClass) {
        ObjectSpecification spec = this.getSpecificationLoader().loadSpecification(ofClass);
        if (spec.isParented()) {
            return this.newAggregatedInstance(this, ofClass);
        }
        ObjectAdapter adapter = this.doCreateTransientInstance(spec);
        return (T)adapter.getObject();
    }

    @Programmatic
    public <T> T newViewModelInstance(Class<T> ofClass, String memento) {
        ObjectSpecification spec = this.getSpecificationLoader().loadSpecification(ofClass);
        if (!spec.containsFacet(ViewModelFacet.class)) {
            throw new IsisException("Type must be a ViewModel: " + ofClass);
        }
        ObjectAdapter adapter = this.doCreateViewModelInstance(spec, memento);
        if (adapter.getOid().isViewModel()) {
            return (T)adapter.getObject();
        }
        throw new IsisException("Object instantiated but was not given a ViewModel Oid; please report as a possible defect in Isis: " + ofClass);
    }

    @Programmatic
    public <T> T newAggregatedInstance(Object parent, Class<T> ofClass) {
        ObjectSpecification spec = this.getSpecificationLoader().loadSpecification(ofClass);
        if (!spec.isParented()) {
            throw new IsisException("Type must be annotated as @Aggregated: " + ofClass);
        }
        ObjectAdapter adapter = this.doCreateAggregatedInstance(spec, parent);
        if (adapter.getOid() instanceof AggregatedOid) {
            return (T)adapter.getObject();
        }
        throw new IsisException("Object instantiated but was not given a AggregatedOid (does the configured object store support aggregates?): " + ofClass);
    }

    @Deprecated
    @Programmatic
    public <T> T newPersistentInstance(Class<T> ofClass) {
        T newInstance = this.newTransientInstance(ofClass);
        this.persist(newInstance);
        return newInstance;
    }

    @Programmatic
    @Deprecated
    public <T> T newInstance(Class<T> ofClass, Object object) {
        if (this.isPersistent(object)) {
            return this.newPersistentInstance(ofClass);
        }
        return this.newTransientInstance(ofClass);
    }

    protected ObjectAdapter doCreateTransientInstance(ObjectSpecification spec) {
        return this.getDomainObjectServices().createTransientInstance(spec);
    }

    protected ObjectAdapter doCreateViewModelInstance(ObjectSpecification spec, String memento) {
        return this.getDomainObjectServices().createViewModelInstance(spec, memento);
    }

    private ObjectAdapter doCreateAggregatedInstance(ObjectSpecification spec, Object parent) {
        ObjectAdapter parentAdapter = this.getAdapterManager().getAdapterFor(parent);
        return this.getDomainObjectServices().createAggregatedInstance(spec, parentAdapter);
    }

    @Programmatic
    public void remove(Object persistentObject) {
        if (persistentObject == null) {
            throw new IllegalArgumentException("Must specify a reference for disposing an object");
        }
        ObjectAdapter adapter = this.getAdapterManager().adapterFor(this.unwrapped(persistentObject));
        if (!this.isPersistent(persistentObject)) {
            throw new RepositoryException("Object not persistent: " + adapter);
        }
        this.getObjectPersistor().remove(adapter);
    }

    @Programmatic
    public void removeIfNotAlready(Object object) {
        if (!this.isPersistent(object)) {
            return;
        }
        this.remove(object);
    }

    @Programmatic
    public <T> T injectServicesInto(T domainObject) {
        this.getDomainObjectServices().injectServicesInto(this.unwrapped(domainObject));
        return domainObject;
    }

    @Programmatic
    public <T> T lookupService(Class<T> service) {
        return this.getDomainObjectServices().lookupService(service);
    }

    @Programmatic
    public <T> Iterable<T> lookupServices(Class<T> service) {
        return this.getDomainObjectServices().lookupServices(service);
    }

    @Deprecated
    @Programmatic
    public void resolve(Object parent) {
        this.getDomainObjectServices().resolve(this.unwrapped(parent));
    }

    @Deprecated
    @Programmatic
    public void resolve(Object parent, Object field) {
        this.getDomainObjectServices().resolve(this.unwrapped(parent), field);
    }

    @Deprecated
    @Programmatic
    public void objectChanged(Object object) {
        this.getObjectDirtier().objectChanged(this.unwrapped(object));
    }

    @Programmatic
    public boolean flush() {
        return this.getDomainObjectServices().flush();
    }

    @Programmatic
    public void commit() {
        this.getDomainObjectServices().commit();
    }

    @Programmatic
    public boolean isValid(Object domainObject) {
        return this.validate(domainObject) == null;
    }

    @Programmatic
    public String validate(Object domainObject) {
        ObjectAdapter adapter = this.getAdapterManager().adapterFor(this.unwrapped(domainObject));
        InteractionResult validityResult = adapter.getSpecification().isValidResult(adapter);
        return validityResult.getReason();
    }

    @Programmatic
    public boolean isViewModel(Object domainObject) {
        ObjectAdapter adapter = this.getAdapterManager().adapterFor(this.unwrapped(domainObject));
        return adapter.getSpecification().isViewModel();
    }

    @Programmatic
    public boolean isPersistent(Object domainObject) {
        ObjectAdapter adapter = this.getAdapterManager().adapterFor(this.unwrapped(domainObject));
        return adapter.representsPersistent();
    }

    @Programmatic
    public void persist(Object domainObject) {
        ObjectAdapter adapter = this.getAdapterManager().adapterFor(this.unwrapped(domainObject));
        if (adapter == null) {
            throw new PersistFailedException("Object not known to framework; instantiate using newTransientInstance(...) rather than simply new'ing up.");
        }
        if (adapter.isParented()) {
            return;
        }
        if (this.isPersistent(domainObject)) {
            throw new PersistFailedException("Object already persistent; OID=" + adapter.getOid());
        }
        this.getObjectPersistor().makePersistent(adapter);
    }

    @Programmatic
    public void persistIfNotAlready(Object object) {
        if (this.isPersistent(object)) {
            return;
        }
        this.persist(object);
    }

    @Programmatic
    public void overrideUser(String user) {
        this.overrideUserAndRoles(user, null);
    }

    @Programmatic
    public void overrideUserAndRoles(String user, List<String> roles) {
        this.overrides.get().push(new UserAndRoleOverrides(user, roles));
    }

    @Programmatic
    public void resetOverrides() {
        this.overrides.get().pop();
    }

    @Programmatic
    public UserMemento getUser() {
        String username;
        AuthenticationSession session = this.getAuthenticationSessionProvider().getAuthenticationSession();
        UserAndRoleOverrides userAndRoleOverrides = this.currentOverridesIfAny();
        String string = username = userAndRoleOverrides != null ? userAndRoleOverrides.user : session.getUserName();
        List<String> roles = userAndRoleOverrides != null ? (userAndRoleOverrides.roles != null ? userAndRoleOverrides.roles : session.getRoles()) : session.getRoles();
        List<RoleMemento> roleMementos = DomainObjectContainerDefault.asRoleMementos(roles);
        UserMemento user = new UserMemento(username, roleMementos);
        return user;
    }

    private UserAndRoleOverrides currentOverridesIfAny() {
        Stack<UserAndRoleOverrides> userAndRoleOverrides = this.overrides.get();
        return !userAndRoleOverrides.empty() ? userAndRoleOverrides.peek() : null;
    }

    private static List<RoleMemento> asRoleMementos(List<String> roles) {
        ArrayList<RoleMemento> mementos = new ArrayList<RoleMemento>();
        if (roles != null) {
            for (String role : roles) {
                mementos.add(new RoleMemento(role));
            }
        }
        return mementos;
    }

    @Programmatic
    public String getProperty(String name) {
        return this.getDomainObjectServices().getProperty(name);
    }

    @Programmatic
    public String getProperty(String name, String defaultValue) {
        String value = this.getProperty(name);
        return value == null ? defaultValue : value;
    }

    @Programmatic
    public List<String> getPropertyNames() {
        return this.getDomainObjectServices().getPropertyNames();
    }

    @Programmatic
    public void informUser(String message) {
        this.getDomainObjectServices().informUser(message);
    }

    public String informUser(TranslatableString message, Class<?> contextClass, String contextMethod) {
        return message.translate(this.translationService, DomainObjectContainerDefault.context(contextClass, contextMethod));
    }

    @Programmatic
    public void warnUser(String message) {
        this.getDomainObjectServices().warnUser(message);
    }

    public String warnUser(TranslatableString message, Class<?> contextClass, String contextMethod) {
        return message.translate(this.translationService, DomainObjectContainerDefault.context(contextClass, contextMethod));
    }

    @Programmatic
    public void raiseError(String message) {
        this.getDomainObjectServices().raiseError(message);
    }

    public String raiseError(TranslatableString message, Class<?> contextClass, String contextMethod) {
        return message.translate(this.translationService, DomainObjectContainerDefault.context(contextClass, contextMethod));
    }

    private static String context(Class<?> contextClass, String contextMethod) {
        return contextClass.getName() + "#" + contextMethod;
    }

    @Programmatic
    public <T> List<T> allInstances(Class<T> type, long ... range) {
        return this.allMatches((Query<T>)new QueryFindAllInstances(type, range));
    }

    @Programmatic
    public <T> List<T> allMatches(Class<T> cls, Predicate<? super T> predicate, long ... range) {
        List<T> allInstances = this.allInstances(cls, range);
        ArrayList<T> filtered = new ArrayList<T>();
        for (T instance : allInstances) {
            if (!predicate.apply(instance)) continue;
            filtered.add(instance);
        }
        return filtered;
    }

    @Programmatic
    @Deprecated
    public <T> List<T> allMatches(Class<T> cls, Filter<? super T> filter, long ... range) {
        return this.allMatches(cls, (T)Filters.asPredicate(filter), range);
    }

    @Programmatic
    public <T> List<T> allMatches(Class<T> type, T pattern, long ... range) {
        Assert.assertTrue("pattern not compatible with type", type.isAssignableFrom(pattern.getClass()));
        return this.allMatches((Query<T>)new QueryFindByPattern<T>(type, pattern, range));
    }

    @Programmatic
    public <T> List<T> allMatches(Class<T> type, String title, long ... range) {
        return this.allMatches((Query<T>)new QueryFindByTitle<T>(type, title, range));
    }

    @Programmatic
    public <T> List<T> allMatches(Query<T> query) {
        if (this.autoFlush) {
            this.flush();
        }
        return this.submitQuery(query);
    }

    <T> List<T> submitQuery(Query<T> query) {
        List<ObjectAdapter> allMatching = this.getQuerySubmitter().allMatchingQuery(query);
        return ObjectAdapter.Util.unwrapT(allMatching);
    }

    @Programmatic
    public <T> T firstMatch(Class<T> cls, Predicate<T> predicate) {
        List<T> allInstances = this.allInstances(cls, new long[0]);
        for (T instance : allInstances) {
            if (!predicate.apply(instance)) continue;
            return instance;
        }
        return null;
    }

    @Programmatic
    @Deprecated
    public <T> T firstMatch(Class<T> cls, Filter<T> filter) {
        return (T)this.firstMatch(cls, (T)Filters.asPredicate(filter));
    }

    @Programmatic
    public <T> T firstMatch(Class<T> type, T pattern) {
        List<T> instances = this.allMatches(type, pattern, 0L, 1L);
        return DomainObjectContainerDefault.firstInstanceElseNull(instances);
    }

    @Programmatic
    public <T> T firstMatch(Class<T> type, String title) {
        List<T> instances = this.allMatches(type, title, 0L, 1L);
        return DomainObjectContainerDefault.firstInstanceElseNull(instances);
    }

    @Programmatic
    public <T> T firstMatch(Query<T> query) {
        this.flush();
        ObjectAdapter firstMatching = this.getQuerySubmitter().firstMatchingQuery(query);
        return (T)ObjectAdapter.Util.unwrap(firstMatching);
    }

    @Programmatic
    public <T> T uniqueMatch(Class<T> type, Predicate<T> predicate) {
        List<Predicate<T>> instances = this.allMatches(type, (T)predicate, 0L, 2L);
        if (instances.size() > 1) {
            throw new RepositoryException("Found more than one instance of " + type + " matching filter " + predicate);
        }
        return (T)DomainObjectContainerDefault.firstInstanceElseNull(instances);
    }

    @Programmatic
    @Deprecated
    public <T> T uniqueMatch(Class<T> type, Filter<T> filter) {
        List<Filter<T>> instances = this.allMatches(type, (T)filter, 0L, 2L);
        if (instances.size() > 1) {
            throw new RepositoryException("Found more than one instance of " + type + " matching filter " + filter);
        }
        return (T)DomainObjectContainerDefault.firstInstanceElseNull(instances);
    }

    @Programmatic
    public <T> T uniqueMatch(Class<T> type, T pattern) {
        List<T> instances = this.allMatches(type, pattern, 0L, 2L);
        if (instances.size() > 1) {
            throw new RepositoryException("Found more that one instance of " + type + " matching pattern " + pattern);
        }
        return DomainObjectContainerDefault.firstInstanceElseNull(instances);
    }

    @Programmatic
    public <T> T uniqueMatch(Class<T> type, String title) {
        List<T> instances = this.allMatches(type, title, 0L, 2L);
        if (instances.size() > 1) {
            throw new RepositoryException("Found more that one instance of " + type + " with title " + title);
        }
        return DomainObjectContainerDefault.firstInstanceElseNull(instances);
    }

    @Programmatic
    public <T> T uniqueMatch(Query<T> query) {
        List<T> instances = this.allMatches(query);
        if (instances.size() > 1) {
            throw new RepositoryException("Found more that one instance for query:" + query.getDescription());
        }
        return DomainObjectContainerDefault.firstInstanceElseNull(instances);
    }

    private static <T> T firstInstanceElseNull(List<T> instances) {
        return instances.size() == 0 ? null : (T)instances.get(0);
    }

    @Programmatic
    public String recognize(Throwable ex) {
        return this.recognizer.recognize(ex);
    }

    @Programmatic
    @PostConstruct
    public void init(Map<String, String> properties) {
        this.injectServicesInto(this.recognizer);
        this.recognizer.init(properties);
        boolean disableAutoFlush = Boolean.parseBoolean(properties.get(KEY_DISABLE_AUTOFLUSH));
        this.autoFlush = !disableAutoFlush;
    }

    @Programmatic
    @PreDestroy
    public void shutdown() {
        this.recognizer.shutdown();
    }

    private Object unwrapped(Object domainObject) {
        return this.wrapperFactory != null ? this.wrapperFactory.unwrap(domainObject) : domainObject;
    }

    protected QuerySubmitter getQuerySubmitter() {
        return this.querySubmitter;
    }

    @Override
    @Programmatic
    public void setQuerySubmitter(QuerySubmitter querySubmitter) {
        this.querySubmitter = querySubmitter;
    }

    protected DomainObjectServices getDomainObjectServices() {
        return this.domainObjectServices;
    }

    @Override
    @Programmatic
    public void setDomainObjectServices(DomainObjectServices domainObjectServices) {
        this.domainObjectServices = domainObjectServices;
    }

    protected SpecificationLoader getSpecificationLoader() {
        return this.specificationLoader;
    }

    @Override
    @Programmatic
    public void setSpecificationLoader(SpecificationLoader specificationLoader) {
        this.specificationLoader = specificationLoader;
    }

    protected AuthenticationSessionProvider getAuthenticationSessionProvider() {
        return this.authenticationSessionProvider;
    }

    @Override
    @Programmatic
    public void setAuthenticationSessionProvider(AuthenticationSessionProvider authenticationSessionProvider) {
        this.authenticationSessionProvider = authenticationSessionProvider;
    }

    protected AdapterManager getAdapterManager() {
        return this.adapterManager;
    }

    @Override
    @Programmatic
    public void setAdapterManager(AdapterManager adapterManager) {
        this.adapterManager = adapterManager;
    }

    protected ObjectDirtier getObjectDirtier() {
        return this.objectDirtier;
    }

    @Override
    @Programmatic
    public void setObjectDirtier(ObjectDirtier objectDirtier) {
        this.objectDirtier = objectDirtier;
    }

    protected ObjectPersistor getObjectPersistor() {
        return this.objectPersistor;
    }

    @Override
    @Programmatic
    public void setObjectPersistor(ObjectPersistor objectPersistor) {
        this.objectPersistor = objectPersistor;
    }

    @Override
    public void setLocalizationProvider(LocalizationProvider localizationProvider) {
        this.localizationProvider = localizationProvider;
    }

    static class ExceptionRecognizerForRecoverableException
    extends ExceptionRecognizerForType {
        public ExceptionRecognizerForRecoverableException() {
            super(ExceptionRecognizer2.Category.CLIENT_ERROR, RecoverableException.class);
        }
    }

    static class ExceptionRecognizerForConcurrencyException
    extends ExceptionRecognizerForType {
        public ExceptionRecognizerForConcurrencyException() {
            super(ExceptionRecognizer2.Category.CONCURRENCY, ConcurrencyException.class, ExceptionRecognizerForConcurrencyException.prefix((String)"Another user has just changed this data"));
        }
    }

    static class UserAndRoleOverrides {
        final String user;
        final List<String> roles;

        UserAndRoleOverrides(String user) {
            this(user, null);
        }

        UserAndRoleOverrides(String user, List<String> roles) {
            this.user = user;
            this.roles = roles;
        }
    }
}

