/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.spec;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.isis.applib.annotation.MemberGroupLayout;
import org.apache.isis.core.metamodel.facets.object.membergroups.MemberGroupLayoutFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;

public final class ObjectSpecifications {
    private ObjectSpecifications() {
    }

    public static List<String> orderByMemberGroups(ObjectSpecification objSpec, Set<String> groupNamesToOrder, MemberGroupLayoutHint memberGroupLayoutHint) {
        MemberGroupLayoutFacet facet = objSpec.getFacet(MemberGroupLayoutFacet.class);
        ArrayList leftColumnGroupNames = Lists.newArrayList(groupNamesToOrder);
        if (facet == null) {
            return leftColumnGroupNames;
        }
        if (memberGroupLayoutHint == MemberGroupLayoutHint.MIDDLE) {
            return facet.getColumnSpans().getMiddle() > 0 ? facet.getMiddle() : Collections.emptyList();
        }
        if (memberGroupLayoutHint == MemberGroupLayoutHint.RIGHT) {
            return facet.getColumnSpans().getRight() > 0 ? facet.getRight() : Collections.emptyList();
        }
        List<String> groupNamedInRequiredOrder = facet.getLeft();
        List<String> order = ObjectSpecifications.order(leftColumnGroupNames, groupNamedInRequiredOrder);
        if (facet.getColumnSpans().getMiddle() > 0) {
            order.removeAll(facet.getMiddle());
        }
        if (facet.getColumnSpans().getRight() > 0) {
            order.removeAll(facet.getRight());
        }
        return order;
    }

    static List<String> order(List<String> valuesToOrder, List<String> valuesInRequiredOrder) {
        int i = 0;
        for (String memberGroup : valuesInRequiredOrder) {
            if (!valuesToOrder.contains(memberGroup)) continue;
            valuesToOrder.remove(memberGroup);
            valuesToOrder.add(i++, memberGroup);
        }
        return valuesToOrder;
    }

    public static enum MemberGroupLayoutHint {
        LEFT,
        MIDDLE,
        RIGHT;


        public int from(MemberGroupLayout.ColumnSpans columnSpans) {
            if (this == LEFT) {
                return columnSpans.getLeft();
            }
            if (this == MIDDLE) {
                return columnSpans.getMiddle();
            }
            if (this == RIGHT) {
                return columnSpans.getRight();
            }
            return 0;
        }
    }
}

