/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader;

import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.isis.core.metamodel.spec.InjectorMethodEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InjectorMethodEvaluatorDefault
implements InjectorMethodEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(InjectorMethodEvaluatorDefault.class);
    private final Map<Method, Map<Class<?>, Boolean>> isInjectorMethod = Maps.newConcurrentMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInjectorMethodFor(Method method, Class<?> serviceClass) {
        Boolean result;
        ConcurrentMap classBooleanMap = this.isInjectorMethod.get(method);
        if (classBooleanMap == null) {
            Map<Method, Map<Class<?>, Boolean>> map = this.isInjectorMethod;
            synchronized (map) {
                classBooleanMap = Maps.newConcurrentMap();
                this.isInjectorMethod.put(method, classBooleanMap);
            }
        }
        if ((result = classBooleanMap.get(serviceClass)) == null) {
            result = InjectorMethodEvaluatorDefault.determineIsInjectorMethodFor(method, serviceClass);
            classBooleanMap.put(serviceClass, result);
        }
        return result;
    }

    private static boolean determineIsInjectorMethodFor(Method method, Class<?> serviceClass) {
        Class<?>[] parameterTypes;
        String methodName = method.getName();
        return (methodName.startsWith("set") || methodName.startsWith("inject")) && (parameterTypes = method.getParameterTypes()).length == 1 && parameterTypes[0] != Object.class && parameterTypes[0].isAssignableFrom(serviceClass);
    }
}

