/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader.specimpl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.lang.ListExtensions;
import org.apache.isis.core.commons.lang.MethodUtil;
import org.apache.isis.core.commons.util.ToString;
import org.apache.isis.core.metamodel.exceptions.MetaModelException;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MethodRemover;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.FacetedMethodParameter;
import org.apache.isis.core.metamodel.facets.actcoll.typeof.TypeOfFacet;
import org.apache.isis.core.metamodel.facets.object.facets.FacetsFacet;
import org.apache.isis.core.metamodel.layoutmetadata.LayoutMetadataReader;
import org.apache.isis.core.metamodel.layoutmetadata.LayoutMetadataReader2;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationLoaderSpi;
import org.apache.isis.core.metamodel.specloader.classsubstitutor.ClassSubstitutor;
import org.apache.isis.core.metamodel.specloader.facetprocessor.FacetProcessor;
import org.apache.isis.core.metamodel.specloader.specimpl.FacetedMethodsBuilderContext;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectSpecificationAbstract;
import org.apache.isis.core.metamodel.specloader.traverser.SpecificationTraverser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FacetedMethodsBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(FacetedMethodsBuilder.class);
    private static final String GET_PREFIX = "get";
    private static final String IS_PREFIX = "is";
    private final FacetHolder spec;
    private final Class<?> introspectedClass;
    private final List<Method> methods;
    private List<FacetedMethod> associationFacetMethods;
    private List<FacetedMethod> actionFacetedMethods;
    private final FacetedMethodsMethodRemover methodRemover;
    private final FacetProcessor facetProcessor;
    private final SpecificationTraverser specificationTraverser = new SpecificationTraverser();
    private final ClassSubstitutor classSubstitutor = new ClassSubstitutor();
    private final SpecificationLoaderSpi specificationLoader;
    private final List<LayoutMetadataReader> layoutMetadataReaders;
    private final Map<LayoutMetadataReader, LayoutMetadataReader2.Support> supportByReader;

    public FacetedMethodsBuilder(ObjectSpecificationAbstract spec, FacetedMethodsBuilderContext facetedMethodsBuilderContext) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("creating JavaIntrospector for " + spec.getFullIdentifier());
        }
        this.spec = spec;
        this.introspectedClass = spec.getCorrespondingClass();
        this.methods = Arrays.asList(this.introspectedClass.getMethods());
        this.methodRemover = new FacetedMethodsMethodRemover(this.methods);
        this.facetProcessor = facetedMethodsBuilderContext.facetProcessor;
        this.specificationLoader = facetedMethodsBuilderContext.specificationLoader;
        this.layoutMetadataReaders = facetedMethodsBuilderContext.layoutMetadataReaders;
        this.supportByReader = Maps.newHashMap();
        for (LayoutMetadataReader reader : this.layoutMetadataReaders) {
            if (!(reader instanceof LayoutMetadataReader2)) continue;
            LayoutMetadataReader2 reader2 = (LayoutMetadataReader2)reader;
            LayoutMetadataReader2.Support support = reader2.support();
            this.supportByReader.put(reader, support);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (LOG.isDebugEnabled()) {
            LOG.debug("finalizing inspector " + this);
        }
    }

    private String getClassName() {
        return this.introspectedClass.getName();
    }

    public Properties introspectClass() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("introspecting " + this.getClassName() + ": class-level details");
        }
        Properties metadataProperties = this.readMetadataProperties(this.introspectedClass);
        this.getFacetProcessor().process(this.introspectedClass, metadataProperties, this.methodRemover, this.spec);
        FacetsFacet facetsFacet = this.spec.getFacet(FacetsFacet.class);
        if (facetsFacet != null) {
            Class<? extends FacetFactory>[] facetFactories;
            for (Class<? extends FacetFactory> facetFactorie : facetFactories = facetsFacet.facetFactories()) {
                FacetFactory facetFactory;
                try {
                    facetFactory = facetFactorie.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new IsisException(e);
                }
                this.getFacetProcessor().injectDependenciesInto(facetFactory);
                facetFactory.process(new FacetFactory.ProcessClassContext(this.introspectedClass, metadataProperties, this.methodRemover, this.spec));
            }
        }
        return metadataProperties;
    }

    private Properties readMetadataProperties(Class<?> domainClass) {
        for (LayoutMetadataReader reader : this.layoutMetadataReaders) {
            try {
                Properties properties;
                LayoutMetadataReader2.Support support;
                if (FacetedMethodsBuilder.isPrimitiveOrJdkOrJodaOrGuava(domainClass) || (support = this.supportByReader.get(reader)) != null && (!support.interfaces() && domainClass.isInterface() || !support.anonymous() && domainClass.isAnonymousClass() || !support.synthetic() && domainClass.isSynthetic() || !support.array() && domainClass.isArray() || !support.enums() && domainClass.isEnum() || !support.applibValueTypes() && domainClass.getName().startsWith("org.apache.isis.applib.value") || !support.services() && this.getSpecificationLoader().isServiceClass(domainClass)) || (properties = reader.asProperties(domainClass)) == null) continue;
                return properties;
            }
            catch (LayoutMetadataReader.ReaderException readerException) {
            }
        }
        return null;
    }

    private static boolean isPrimitiveOrJdkOrJodaOrGuava(Class<?> cls) {
        if (cls.isPrimitive()) {
            return true;
        }
        String className = cls.getName();
        return className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("org.joda") || className.startsWith("com.google.common");
    }

    public List<FacetedMethod> getAssociationFacetedMethods(Properties properties) {
        if (this.associationFacetMethods == null) {
            this.associationFacetMethods = this.createAssociationFacetedMethods(properties);
        }
        return this.associationFacetMethods;
    }

    private List<FacetedMethod> createAssociationFacetedMethods(Properties properties) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("introspecting " + this.getClassName() + ": properties and collections");
        }
        Set<Method> associationCandidateMethods = this.getFacetProcessor().findAssociationCandidateAccessors(this.methods, new HashSet<Method>());
        ArrayList typesToLoad = Lists.newArrayList();
        for (Method method : associationCandidateMethods) {
            this.specificationTraverser.traverseTypes(method, typesToLoad);
        }
        this.getSpecificationLoader().loadSpecifications(typesToLoad, this.introspectedClass);
        ArrayList associationFacetedMethods = Lists.newArrayList();
        this.findAndRemoveCollectionAccessorsAndCreateCorrespondingFacetedMethods(associationFacetedMethods, properties);
        this.findAndRemovePropertyAccessorsAndCreateCorrespondingFacetedMethods(associationFacetedMethods, properties);
        return Collections.unmodifiableList(associationFacetedMethods);
    }

    private void findAndRemoveCollectionAccessorsAndCreateCorrespondingFacetedMethods(List<FacetedMethod> associationPeers, Properties properties) {
        ArrayList collectionAccessors = Lists.newArrayList();
        this.getFacetProcessor().findAndRemoveCollectionAccessors(this.methodRemover, collectionAccessors);
        this.createCollectionFacetedMethodsFromAccessors(collectionAccessors, associationPeers, properties);
    }

    private void findAndRemovePropertyAccessorsAndCreateCorrespondingFacetedMethods(List<FacetedMethod> fields, Properties properties) {
        ArrayList propertyAccessors = Lists.newArrayList();
        this.getFacetProcessor().findAndRemovePropertyAccessors(this.methodRemover, propertyAccessors);
        this.findAndRemovePrefixedNonVoidMethods(MethodScope.OBJECT, GET_PREFIX, Object.class, 0, propertyAccessors);
        this.findAndRemovePrefixedNonVoidMethods(MethodScope.OBJECT, IS_PREFIX, Boolean.class, 0, propertyAccessors);
        this.createPropertyFacetedMethodsFromAccessors(propertyAccessors, fields, properties);
    }

    private void createCollectionFacetedMethodsFromAccessors(List<Method> accessorMethods, List<FacetedMethod> facetMethodsToAppendto, Properties properties) {
        for (Method accessorMethod : accessorMethods) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("  identified accessor method representing collection: " + accessorMethod);
            }
            FacetedMethod facetedMethod = FacetedMethod.createForCollection(this.introspectedClass, accessorMethod);
            this.getFacetProcessor().process(this.introspectedClass, accessorMethod, this.methodRemover, facetedMethod, FeatureType.COLLECTION, properties);
            Class elementType = Object.class;
            TypeOfFacet typeOfFacet = facetedMethod.getFacet(TypeOfFacet.class);
            if (typeOfFacet != null) {
                elementType = typeOfFacet.value();
            }
            facetedMethod.setType(elementType);
            if (this.classSubstitutor.getClass(elementType) == null) continue;
            facetMethodsToAppendto.add(facetedMethod);
        }
    }

    private void createPropertyFacetedMethodsFromAccessors(List<Method> accessorMethods, List<FacetedMethod> facetedMethodsToAppendto, Properties properties) throws MetaModelException {
        for (Method accessorMethod : accessorMethods) {
            LOG.debug("  identified accessor method representing property: " + accessorMethod);
            Class<?> returnType = accessorMethod.getReturnType();
            if (this.classSubstitutor.getClass(returnType) == null) continue;
            FacetedMethod facetedMethod = FacetedMethod.createForProperty(this.introspectedClass, accessorMethod);
            this.getFacetProcessor().process(this.introspectedClass, accessorMethod, this.methodRemover, facetedMethod, FeatureType.PROPERTY, properties);
            facetedMethodsToAppendto.add(facetedMethod);
        }
    }

    public List<FacetedMethod> getActionFacetedMethods(Properties metadataProperties) {
        if (this.actionFacetedMethods == null) {
            this.actionFacetedMethods = this.findActionFacetedMethods(MethodScope.OBJECT, metadataProperties);
        }
        return this.actionFacetedMethods;
    }

    private List<FacetedMethod> findActionFacetedMethods(MethodScope methodScope, Properties metadataProperties) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("introspecting " + this.getClassName() + ": actions");
        }
        List<FacetedMethod> actionFacetedMethods1 = this.findActionFacetedMethods(methodScope, RecognisedHelpersStrategy.SKIP, metadataProperties);
        List<FacetedMethod> actionFacetedMethods2 = this.findActionFacetedMethods(methodScope, RecognisedHelpersStrategy.DONT_SKIP, metadataProperties);
        return ListExtensions.combineWith(actionFacetedMethods1, actionFacetedMethods2);
    }

    private List<FacetedMethod> findActionFacetedMethods(MethodScope methodScope, RecognisedHelpersStrategy recognisedHelpersStrategy, Properties metadataProperties) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("  looking for action methods");
        }
        ArrayList actionFacetedMethods = Lists.newArrayList();
        for (int i = 0; i < this.methods.size(); ++i) {
            FacetedMethod actionPeer;
            Method method = this.methods.get(i);
            if (method == null || (actionPeer = this.findActionFacetedMethod(methodScope, recognisedHelpersStrategy, method, metadataProperties)) == null) continue;
            this.methods.set(i, null);
            actionFacetedMethods.add(actionPeer);
        }
        return actionFacetedMethods;
    }

    private FacetedMethod findActionFacetedMethod(MethodScope methodScope, RecognisedHelpersStrategy recognisedHelpersStrategy, Method actionMethod, Properties metadataProperties) {
        if (!this.representsAction(actionMethod, methodScope, recognisedHelpersStrategy)) {
            return null;
        }
        return this.createActionFacetedMethod(actionMethod, metadataProperties);
    }

    private FacetedMethod createActionFacetedMethod(Method actionMethod, Properties metadataProperties) {
        if (!this.isAllParamTypesValid(actionMethod)) {
            return null;
        }
        FacetedMethod action = FacetedMethod.createForAction(this.introspectedClass, actionMethod);
        this.getFacetProcessor().process(this.introspectedClass, actionMethod, this.methodRemover, action, FeatureType.ACTION, metadataProperties);
        List<FacetedMethodParameter> actionParams = action.getParameters();
        for (int j = 0; j < actionParams.size(); ++j) {
            this.getFacetProcessor().processParams(this.introspectedClass, actionMethod, j, this.methodRemover, actionParams.get(j));
        }
        return action;
    }

    private boolean isAllParamTypesValid(Method actionMethod) {
        for (Class<?> paramType : actionMethod.getParameterTypes()) {
            ObjectSpecification paramSpec = this.getSpecificationLoader().loadSpecification(paramType);
            if (paramSpec != null) continue;
            return false;
        }
        return true;
    }

    private boolean representsAction(Method actionMethod, MethodScope methodScope, RecognisedHelpersStrategy recognisedHelpersStrategy) {
        if (!MethodUtil.inScope(actionMethod, methodScope)) {
            return false;
        }
        ArrayList typesToLoad = new ArrayList();
        this.specificationTraverser.traverseTypes(actionMethod, typesToLoad);
        boolean anyLoadedAsNull = this.getSpecificationLoader().loadSpecifications(typesToLoad);
        if (anyLoadedAsNull) {
            return false;
        }
        if (!this.loadParamSpecs(actionMethod)) {
            return false;
        }
        if (this.getFacetProcessor().recognizes(actionMethod)) {
            if (actionMethod.getName().startsWith("set")) {
                return false;
            }
            if (recognisedHelpersStrategy.skip()) {
                LOG.debug("  skipping possible helper method {0}", (Object)actionMethod);
                return false;
            }
        }
        LOG.debug("  identified action {0}", (Object)actionMethod);
        return true;
    }

    private boolean loadParamSpecs(Method actionMethod) {
        Class<?>[] parameterTypes = actionMethod.getParameterTypes();
        return this.loadParamSpecs(parameterTypes);
    }

    private boolean loadParamSpecs(Class<?>[] parameterTypes) {
        int numParameters = parameterTypes.length;
        for (int j = 0; j < numParameters; ++j) {
            ObjectSpecification paramSpec = this.getSpecificationLoader().loadSpecification(parameterTypes[j]);
            if (paramSpec != null) continue;
            return false;
        }
        return true;
    }

    public void introspectClassPostProcessing(Properties metadataProperties) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("introspecting {0}: class-level post-processing", (Object)this.getClassName());
        }
        this.getFacetProcessor().processPost(this.introspectedClass, metadataProperties, this.methodRemover, this.spec);
    }

    private void findAndRemovePrefixedNonVoidMethods(MethodScope methodScope, String prefix, Class<?> returnType, int paramCount, List<Method> methodListToAppendTo) {
        List<Method> matchingMethods = this.findAndRemovePrefixedMethods(methodScope, prefix, returnType, false, paramCount);
        methodListToAppendTo.addAll(matchingMethods);
    }

    private List<Method> findAndRemovePrefixedMethods(MethodScope methodScope, String prefix, Class<?> returnType, boolean canBeVoid, int paramCount) {
        return MethodUtil.removeMethods(this.methods, methodScope, prefix, returnType, canBeVoid, paramCount);
    }

    public String toString() {
        ToString str = new ToString(this);
        str.append("class", this.getClassName());
        return str.toString();
    }

    private SpecificationLoaderSpi getSpecificationLoader() {
        return this.specificationLoader;
    }

    private FacetProcessor getFacetProcessor() {
        return this.facetProcessor;
    }

    private static enum RecognisedHelpersStrategy {
        SKIP,
        DONT_SKIP;


        public boolean skip() {
            return this == SKIP;
        }
    }

    private static final class FacetedMethodsMethodRemover
    implements MethodRemover {
        private final List<Method> methods;

        private FacetedMethodsMethodRemover(List<Method> methods) {
            this.methods = methods;
        }

        @Override
        public void removeMethod(MethodScope methodScope, String methodName, Class<?> returnType, Class<?>[] parameterTypes) {
            MethodUtil.removeMethod(this.methods, methodScope, methodName, returnType, parameterTypes);
        }

        @Override
        public List<Method> removeMethods(MethodScope methodScope, String prefix, Class<?> returnType, boolean canBeVoid, int paramCount) {
            return MethodUtil.removeMethods(this.methods, methodScope, prefix, returnType, canBeVoid, paramCount);
        }

        @Override
        public void removeMethod(Method method) {
            if (method == null) {
                return;
            }
            for (int i = 0; i < this.methods.size(); ++i) {
                if (this.methods.get(i) == null || !this.methods.get(i).equals(method)) continue;
                this.methods.set(i, null);
            }
        }

        @Override
        public void removeMethods(List<Method> methodsToRemove) {
            block0: for (int i = 0; i < this.methods.size(); ++i) {
                if (this.methods.get(i) == null) continue;
                for (Method method : methodsToRemove) {
                    if (!this.methods.get(i).equals(method)) continue;
                    this.methods.set(i, null);
                    continue block0;
                }
            }
        }
    }
}

