/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader.specimpl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.annotation.Bulk;
import org.apache.isis.applib.annotation.InvokedOn;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.filter.Filter;
import org.apache.isis.applib.services.actinvoc.ActionInvocationContext;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.command.Command;
import org.apache.isis.applib.services.command.CommandContext;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.lang.ObjectExtensions;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.consent.InteractionInvocationMethod;
import org.apache.isis.core.metamodel.deployment.DeploymentCategory;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetHolderImpl;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.MultiTypedFacet;
import org.apache.isis.core.metamodel.facets.actions.action.invocation.CommandUtil;
import org.apache.isis.core.metamodel.facets.actions.bulk.BulkFacet;
import org.apache.isis.core.metamodel.interactions.InteractionUtils;
import org.apache.isis.core.metamodel.interactions.UsabilityContext;
import org.apache.isis.core.metamodel.interactions.VisibilityContext;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.isis.core.metamodel.spec.feature.ObjectMemberContext;
import org.apache.isis.core.metamodel.specloader.specimpl.ContributeeMember;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectActionImpl;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectActionParameterAbstract;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectActionParameterContributee;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectActionParameterParseable;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectActionParameterParseableContributee;
import org.apache.isis.core.metamodel.specloader.specimpl.OneToOneActionParameterContributee;
import org.apache.isis.core.metamodel.specloader.specimpl.OneToOneActionParameterImpl;

public class ObjectActionContributee
extends ObjectActionImpl
implements ContributeeMember {
    private final ObjectAdapter serviceAdapter;
    private final ObjectActionImpl serviceAction;
    private final int contributeeParam;
    private final ObjectSpecification contributeeType;
    private final FacetHolder facetHolder = new FacetHolderImpl();
    private List<ObjectActionParameterContributee> parameters;
    private final Identifier identifier;

    public ObjectActionContributee(ObjectAdapter serviceAdapter, ObjectActionImpl serviceAction, int contributeeParam, ObjectSpecification contributeeType, ObjectMemberContext objectMemberContext) {
        super(serviceAction.getFacetedMethod(), objectMemberContext);
        this.serviceAdapter = serviceAdapter;
        this.serviceAction = serviceAction;
        this.contributeeType = contributeeType;
        this.contributeeParam = contributeeParam;
        FacetUtil.copyFacets(serviceAction.getFacetedMethod(), this.facetHolder);
        Identifier contributorIdentifier = serviceAction.getFacetedMethod().getIdentifier();
        String memberName = contributorIdentifier.getMemberName();
        List memberParameterNames = contributorIdentifier.getMemberParameterNames();
        this.identifier = Identifier.actionIdentifier((String)this.getOnType().getCorrespondingClass().getName(), (String)memberName, (List)memberParameterNames);
    }

    @Override
    public ObjectSpecification getOnType() {
        return this.contributeeType;
    }

    @Override
    public int getParameterCount() {
        return this.serviceAction.getParameterCount() - 1;
    }

    public int getContributeeParam() {
        return this.contributeeParam;
    }

    @Override
    public boolean isContributedBy(ObjectAction serviceAction) {
        return serviceAction == this.serviceAction;
    }

    @Override
    public int getContributeeParamPosition() {
        return this.contributeeParam;
    }

    @Override
    public synchronized List<ObjectActionParameter> getParameters() {
        if (this.parameters == null) {
            List<ObjectActionParameter> serviceParameters = this.serviceAction.getParameters();
            ArrayList contributeeParameters = Lists.newArrayList();
            int contributeeParamNum = 0;
            for (int serviceParamNum = 0; serviceParamNum < serviceParameters.size(); ++serviceParamNum) {
                ObjectActionParameterAbstract contributedParam;
                if (serviceParamNum == this.contributeeParam) continue;
                ObjectActionParameterAbstract serviceParameter = (ObjectActionParameterAbstract)serviceParameters.get(serviceParamNum);
                if (serviceParameter instanceof ObjectActionParameterParseable) {
                    contributedParam = new ObjectActionParameterParseableContributee(this.serviceAdapter, this.serviceAction, serviceParameter, serviceParamNum, contributeeParamNum, this);
                } else if (serviceParameter instanceof OneToOneActionParameterImpl) {
                    contributedParam = new OneToOneActionParameterContributee(this.serviceAdapter, this.serviceAction, serviceParameter, serviceParamNum, contributeeParamNum, this);
                } else {
                    throw new RuntimeException("Unknown implementation of ObjectActionParameter; " + serviceParameter.getClass().getName());
                }
                contributeeParameters.add(contributedParam);
                ++contributeeParamNum;
            }
            this.parameters = contributeeParameters;
        }
        return ObjectExtensions.asListT(this.parameters, ObjectActionParameter.class);
    }

    @Override
    public Consent isVisible(AuthenticationSession session, ObjectAdapter contributee, Where where) {
        VisibilityContext<?> ic = this.serviceAction.createVisibleInteractionContext(session, InteractionInvocationMethod.BY_USER, this.serviceAdapter, where);
        ic.putContributee(this.contributeeParam, contributee);
        return InteractionUtils.isVisibleResult(this, ic).createConsent();
    }

    @Override
    public Consent isUsable(AuthenticationSession session, ObjectAdapter contributee, Where where) {
        UsabilityContext<?> ic = this.serviceAction.createUsableInteractionContext(session, InteractionInvocationMethod.BY_USER, this.serviceAdapter, where);
        ic.putContributee(this.contributeeParam, contributee);
        return InteractionUtils.isUsableResult(this, ic).createConsent();
    }

    @Override
    public ObjectAdapter[] getDefaults(ObjectAdapter target) {
        ObjectAdapter[] contributorDefaults = this.serviceAction.getDefaults(this.serviceAdapter);
        return ObjectActionContributee.removeElementFromArray(contributorDefaults, this.contributeeParam, new ObjectAdapter[0]);
    }

    @Override
    public ObjectAdapter[][] getChoices(ObjectAdapter target, AuthenticationSession authenticationSession, DeploymentCategory deploymentCategory) {
        ObjectAdapter[][] serviceChoices = this.serviceAction.getChoices(this.serviceAdapter, authenticationSession, deploymentCategory);
        return (ObjectAdapter[][])ObjectActionContributee.removeElementFromArray(serviceChoices, this.contributeeParam, new ObjectAdapter[0][]);
    }

    @Override
    public Consent isProposedArgumentSetValid(ObjectAdapter contributee, ObjectAdapter[] proposedArguments) {
        ObjectAdapter[] serviceArguments = this.argsPlusContributee(contributee, proposedArguments);
        return this.serviceAction.isProposedArgumentSetValid(this.serviceAdapter, serviceArguments);
    }

    @Override
    public ObjectAdapter execute(ObjectAdapter contributee, ObjectAdapter[] arguments) {
        CommandContext commandContext;
        Command command;
        BulkFacet bulkFacet = this.getFacet(BulkFacet.class);
        if (bulkFacet != null) {
            Bulk.InteractionContext bulkInteractionContext;
            ActionInvocationContext actionInvocationContext = this.getServicesProvider().lookupService(ActionInvocationContext.class);
            if (actionInvocationContext != null && actionInvocationContext.getInvokedOn() == null) {
                actionInvocationContext.setInvokedOn(InvokedOn.OBJECT);
                actionInvocationContext.setDomainObjects(Collections.singletonList(contributee.getObject()));
            }
            if ((bulkInteractionContext = this.getServicesProvider().lookupService(Bulk.InteractionContext.class)) != null && bulkInteractionContext.getInvokedAs() == null) {
                bulkInteractionContext.setInvokedAs(Bulk.InteractionContext.InvokedAs.REGULAR);
                actionInvocationContext.setDomainObjects(Collections.singletonList(contributee.getObject()));
            }
        }
        Command command2 = command = (commandContext = this.getServicesProvider().lookupService(CommandContext.class)) != null ? commandContext.getCommand() : null;
        if (command != null && command.getExecutor() == Command.Executor.USER && command.getTarget() == null) {
            command.setTargetClass(CommandUtil.targetClassNameFor(contributee));
            command.setTargetAction(CommandUtil.targetActionNameFor(this));
            command.setArguments(CommandUtil.argDescriptionFor(this, arguments));
            Bookmark targetBookmark = CommandUtil.bookmarkFor(contributee);
            command.setTarget(targetBookmark);
        }
        return this.serviceAction.execute(this.serviceAdapter, this.argsPlusContributee(contributee, arguments));
    }

    private ObjectAdapter[] argsPlusContributee(ObjectAdapter contributee, ObjectAdapter[] arguments) {
        return ObjectActionContributee.addElementToArray(arguments, this.contributeeParam, contributee, new ObjectAdapter[0]);
    }

    @Override
    public Class<? extends Facet>[] getFacetTypes() {
        return this.facetHolder.getFacetTypes();
    }

    @Override
    public <T extends Facet> T getFacet(Class<T> cls) {
        return this.facetHolder.getFacet(cls);
    }

    @Override
    public boolean containsFacet(Class<? extends Facet> facetType) {
        return this.facetHolder.containsFacet(facetType);
    }

    @Override
    public boolean containsDoOpFacet(Class<? extends Facet> facetType) {
        return this.facetHolder.containsDoOpFacet(facetType);
    }

    @Override
    public List<Facet> getFacets(Filter<Facet> filter) {
        return this.facetHolder.getFacets(filter);
    }

    @Override
    public void addFacet(Facet facet) {
        this.facetHolder.addFacet(facet);
    }

    @Override
    public void addFacet(MultiTypedFacet facet) {
        this.facetHolder.addFacet(facet);
    }

    @Override
    public void removeFacet(Facet facet) {
        this.facetHolder.removeFacet(facet);
    }

    @Override
    public void removeFacet(Class<? extends Facet> facetType) {
        this.facetHolder.removeFacet(facetType);
    }

    @Override
    public Identifier getIdentifier() {
        return this.identifier;
    }

    static <T> T[] addElementToArray(T[] array, int n, T element, T[] type) {
        ArrayList list = Lists.newArrayList(Arrays.asList(array));
        list.add(n, element);
        return list.toArray(type);
    }

    static <T> T[] removeElementFromArray(T[] array, int n, T[] t) {
        ArrayList list = Lists.newArrayList(Arrays.asList(array));
        list.remove(n);
        return list.toArray(t);
    }
}

