/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader.specimpl;

import java.util.List;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.lang.ListExtensions;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.deployment.DeploymentCategory;
import org.apache.isis.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectActionContributee;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectActionImpl;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectActionParameterAbstract;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectActionParameterContributee;
import org.apache.isis.core.metamodel.specloader.specimpl.OneToOneActionParameterImpl;

public class OneToOneActionParameterContributee
extends OneToOneActionParameterImpl
implements ObjectActionParameterContributee {
    private final ObjectAdapter serviceAdapter;
    private final ObjectActionImpl serviceAction;
    private final ObjectActionParameter serviceActionParameter;
    private final int serviceParamNumber;
    private final int contributeeParamNumber;
    private final ObjectActionContributee contributeeAction;

    public OneToOneActionParameterContributee(ObjectAdapter serviceAdapter, ObjectActionImpl serviceAction, ObjectActionParameterAbstract serviceActionParameter, int serviceParamNumber, int contributeeParamNumber, ObjectActionContributee contributeeAction) {
        super(contributeeParamNumber, contributeeAction, serviceActionParameter.getPeer());
        this.serviceAdapter = serviceAdapter;
        this.serviceAction = serviceAction;
        this.serviceActionParameter = serviceActionParameter;
        this.serviceParamNumber = serviceParamNumber;
        this.contributeeParamNumber = contributeeParamNumber;
        this.contributeeAction = contributeeAction;
    }

    @Override
    public ObjectAdapter[] getAutoComplete(ObjectAdapter adapter, String searchArg, AuthenticationSession authenticationSession, DeploymentCategory deploymentCategory) {
        return this.serviceActionParameter.getAutoComplete(this.serviceAdapter, searchArg, authenticationSession, deploymentCategory);
    }

    @Override
    protected ObjectAdapter targetForDefaultOrChoices(ObjectAdapter adapter, List<ObjectAdapter> argumentsIfAvailable) {
        return this.serviceAdapter;
    }

    @Override
    protected List<ObjectAdapter> argsForDefaultOrChoices(ObjectAdapter contributee, List<ObjectAdapter> argumentsIfAvailable) {
        List<ObjectAdapter> suppliedArgs = ListExtensions.mutableCopy(argumentsIfAvailable);
        int contributeeParam = this.contributeeAction.getContributeeParam();
        ListExtensions.insert(suppliedArgs, contributeeParam, contributee);
        return suppliedArgs;
    }
}

