/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader.validator;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelInvalidException;

public final class ValidationFailures
implements Iterable<String> {
    private final Set<String> messages = Sets.newLinkedHashSet();

    public void add(String pattern, Object ... arguments) {
        String message = String.format(pattern, arguments);
        this.messages.add(message);
    }

    public void addAll(Iterable<String> messages) {
        for (String message : messages) {
            this.messages.add(message);
        }
    }

    public void add(ValidationFailures validationFailures) {
        this.addAll(validationFailures.getMessages());
    }

    public void assertNone() {
        if (!this.occurred()) {
            return;
        }
        TreeSet sortedMessages = Sets.newTreeSet(this.messages);
        throw new MetaModelInvalidException(sortedMessages);
    }

    public boolean occurred() {
        return !this.messages.isEmpty();
    }

    public Set<String> getMessages() {
        return Collections.unmodifiableSet(this.messages);
    }

    public int getNumberOfMessages() {
        return this.messages.size();
    }

    @Override
    public Iterator<String> iterator() {
        return this.getMessages().iterator();
    }
}

