/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.authorization.standard;

import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.runtime.authorization.AuthorizationManager;
import org.apache.isis.core.runtime.authorization.standard.AuthorizationFacetImpl;

public class AuthorizationFacetFactory
extends FacetFactoryAbstract {
    private final AuthorizationManager authorizationManager;

    public AuthorizationFacetFactory(AuthorizationManager authorizationManager) {
        super(FeatureType.EVERYTHING_BUT_PARAMETERS);
        this.authorizationManager = authorizationManager;
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContext) {
        FacetUtil.addFacet(this.createFacet((FacetHolder)processClassContext.getFacetHolder()));
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        FacetUtil.addFacet(this.createFacet((FacetHolder)processMethodContext.getFacetHolder()));
    }

    private AuthorizationFacetImpl createFacet(FacetHolder holder) {
        AuthorizationManager authorizationManager = this.getAuthorizationManager();
        return new AuthorizationFacetImpl(holder, authorizationManager);
    }

    private AuthorizationManager getAuthorizationManager() {
        return this.authorizationManager;
    }
}

