/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.authorization.standard;

import org.apache.isis.applib.Identifier;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.commons.debug.DebuggableWithTitle;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.progmodel.ProgrammingModel;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.runtime.authorization.AuthorizationManagerAbstract;
import org.apache.isis.core.runtime.authorization.standard.AuthorizationFacetFactory;
import org.apache.isis.core.runtime.authorization.standard.Authorizor;

public class AuthorizationManagerStandard
extends AuthorizationManagerAbstract
implements DebuggableWithTitle {
    private Authorizor authorizor = new Authorizor(){

        @Override
        public void init() {
        }

        @Override
        public void shutdown() {
        }

        @Override
        public boolean isVisibleInRole(String user, Identifier identifier) {
            return true;
        }

        @Override
        public boolean isUsableInRole(String role, Identifier identifier) {
            return true;
        }

        @Override
        public boolean isVisibleInAnyRole(Identifier identifier) {
            return true;
        }

        @Override
        public boolean isUsableInAnyRole(Identifier identifier) {
            return true;
        }
    };

    public AuthorizationManagerStandard(IsisConfiguration configuration) {
        super(configuration);
    }

    @Override
    public void init() {
        this.authorizor.init();
    }

    @Override
    public void shutdown() {
        this.authorizor.shutdown();
    }

    @Override
    public boolean isUsable(AuthenticationSession session, ObjectAdapter target, Identifier identifier) {
        if (this.isPerspectiveMember(identifier)) {
            return true;
        }
        if (this.authorizor.isUsableInAnyRole(identifier)) {
            return true;
        }
        for (String roleName : session.getRoles()) {
            if (!this.authorizor.isUsableInRole(roleName, identifier)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isVisible(AuthenticationSession session, ObjectAdapter target, Identifier identifier) {
        if (this.isPerspectiveMember(identifier)) {
            return true;
        }
        if (identifier.getMemberName().equals("")) {
            return true;
        }
        if (this.authorizor.isVisibleInAnyRole(identifier)) {
            return true;
        }
        for (String roleName : session.getRoles()) {
            if (!this.authorizor.isVisibleInRole(roleName, identifier)) continue;
            return true;
        }
        return false;
    }

    private boolean isPerspectiveMember(Identifier identifier) {
        return identifier.getClassName().equals("");
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite baseMetaModelValidator, IsisConfiguration configuration) {
    }

    @Override
    public void refineProgrammingModel(ProgrammingModel baseProgrammingModel, IsisConfiguration configuration) {
        AuthorizationFacetFactory facetFactory = new AuthorizationFacetFactory(this);
        baseProgrammingModel.addFactory(facetFactory);
    }

    @Override
    public String debugTitle() {
        return "Authorization Manager";
    }

    @Override
    public void debugData(DebugBuilder debug) {
        debug.appendTitle("Authorizor Manager");
        debug.appendln("Authorizer", this.authorizor);
    }

    protected void setAuthorizor(Authorizor authorisor) {
        this.authorizor = authorisor;
    }
}

