/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.snapshot;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.isis.core.runtime.snapshot.Helper;
import org.apache.isis.core.runtime.snapshot.IsisSchema;
import org.apache.isis.core.runtime.snapshot.Place;
import org.apache.isis.core.runtime.snapshot.XsMetaModel;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public final class XmlSchema {
    private final String prefix;
    private final String uriBase;
    private String uri;
    private final IsisSchema isisMeta = new IsisSchema();
    private final XsMetaModel xsMeta = new XsMetaModel();
    private final Helper helper = new Helper();
    public static final String DEFAULT_PREFIX = "app";

    public XmlSchema() {
        this("http://isis.apache.org/ns/app/", DEFAULT_PREFIX);
    }

    public XmlSchema(String uriBase, String prefix) {
        String base = new Helper().trailingSlash(uriBase);
        if ("http://www.w3.org/2000/xmlns/".equals(base)) {
            throw new IllegalArgumentException("Namespace URI reserved for w3.org XMLNS namespace");
        }
        if ("xmlns".equals(prefix)) {
            throw new IllegalArgumentException("Namespace prefix reserved for w3.org XMLNS namespace.");
        }
        if ("http://www.w3.org/2001/XMLSchema".equals(base)) {
            throw new IllegalArgumentException("Namespace URI reserved for w3.org XML schema namespace.");
        }
        if ("xs".equals(prefix)) {
            throw new IllegalArgumentException("Namespace prefix reserved for w3.org XML schema namespace.");
        }
        if ("http://www.w3.org/2001/XMLSchema-instance".equals(base)) {
            throw new IllegalArgumentException("Namespace URI reserved for w3.org XML schema-instance namespace.");
        }
        if ("xsi".equals(prefix)) {
            throw new IllegalArgumentException("Namespace prefix reserved for w3.org XML schema-instance namespace.");
        }
        if ("http://isis.apache.org/ns/0.1/metamodel".equals(base)) {
            throw new IllegalArgumentException("Namespace URI reserved for NOF metamodel namespace.");
        }
        if ("isis".equals(prefix)) {
            throw new IllegalArgumentException("Namespace prefix reserved for NOF metamodel namespace.");
        }
        this.uriBase = base;
        this.prefix = prefix;
    }

    public String getUriBase() {
        return this.uriBase;
    }

    void setUri(String fullyQualifiedClassName) {
        if (this.uri != null) {
            throw new IllegalStateException("URI has already been specified.");
        }
        this.uri = this.getUriBase() + this.helper.packageNameFor(fullyQualifiedClassName) + "/" + this.helper.classNameFor(fullyQualifiedClassName);
    }

    public String getUri() {
        if (this.uri == null) {
            throw new IllegalStateException("URI has not been specified.");
        }
        return this.uri;
    }

    public String getPrefix() {
        return this.prefix;
    }

    Element createElement(Document doc, String localName, String fullyQualifiedClassName, String singularName, String pluralName) {
        Element element = doc.createElementNS(this.getUri(), this.getPrefix() + ":" + localName);
        element.setAttributeNS("http://isis.apache.org/ns/0.1/metamodel", "isis:fqn", fullyQualifiedClassName);
        element.setAttributeNS("http://isis.apache.org/ns/0.1/metamodel", "isis:singular", singularName);
        element.setAttributeNS("http://isis.apache.org/ns/0.1/metamodel", "isis:plural", pluralName);
        this.isisMeta.addNamespace(element);
        this.addNamespace(element, this.getPrefix(), this.getUri());
        return element;
    }

    void setTargetNamespace(Document xsdDoc, String fullyQualifiedClassName) {
        Element xsSchemaElement = xsdDoc.getDocumentElement();
        if (xsSchemaElement == null) {
            throw new IllegalArgumentException("XSD Document must have <xs:schema> element attached");
        }
        xsSchemaElement.setAttribute("targetNamespace", this.getUri());
        this.addNamespace(xsSchemaElement, this.getPrefix(), this.getUri());
    }

    Element createXsElementForNofClass(Document xsdDoc, Element element, boolean addCardinality, Hashtable extensions) {
        String localName = element.getLocalName();
        Element xsElementForNofClassElement = this.xsMeta.createXsElementElement(xsdDoc, localName, addCardinality);
        Element xsComplexTypeElement = this.xsMeta.complexTypeFor(xsElementForNofClassElement);
        Element xsSequenceElement = this.xsMeta.sequenceFor(xsComplexTypeElement);
        Element xsTitleElement = this.xsMeta.createXsElement(this.helper.docFor(xsSequenceElement), "element");
        xsTitleElement.setAttribute("ref", "isis:title");
        xsSequenceElement.appendChild(xsTitleElement);
        this.xsMeta.setXsCardinality(xsTitleElement, 0, 1);
        this.addXsElementForAppExtensions(xsSequenceElement, extensions);
        this.xsMeta.addXsIsisFeatureAttributeElements(xsComplexTypeElement, "class");
        this.xsMeta.addXsIsisAttribute(xsComplexTypeElement, "oid");
        this.xsMeta.addXsIsisAttribute(xsComplexTypeElement, "fqn");
        this.xsMeta.addXsIsisAttribute(xsComplexTypeElement, "singular");
        this.xsMeta.addXsIsisAttribute(xsComplexTypeElement, "plural");
        this.xsMeta.addXsIsisAttribute(xsComplexTypeElement, "annotation");
        Place.setXsdElement(element, xsElementForNofClassElement);
        return xsElementForNofClassElement;
    }

    void addXsElementForAppExtensions(Element parentXsElementElement, Hashtable extensions) {
        if (extensions.size() == 0) {
            return;
        }
        Element xsExtensionsSequenceElement = this.addExtensionsElement(parentXsElementElement);
        this.addExtensionElements(xsExtensionsSequenceElement, extensions);
    }

    private Element addExtensionsElement(Element parentXsElement) {
        Element xsExtensionsElementElement = this.xsMeta.createXsElementElement(this.helper.docFor(parentXsElement), "isis-extensions");
        parentXsElement.appendChild(xsExtensionsElementElement);
        Element xsExtensionsComplexTypeElement = this.xsMeta.complexTypeFor(xsExtensionsElementElement);
        Element xsExtensionsSequenceElement = this.xsMeta.sequenceFor(xsExtensionsComplexTypeElement);
        return xsExtensionsSequenceElement;
    }

    private String shortName(String className) {
        int lastPeriodIdx = className.lastIndexOf(46);
        if (lastPeriodIdx < 0) {
            return className;
        }
        return className.substring(lastPeriodIdx + 1);
    }

    Element createXsElementForNofValue(Element parentXsElementElement, Element xmlValueElement, Hashtable extensions) {
        String datatype = xmlValueElement.getAttributeNS("http://isis.apache.org/ns/0.1/metamodel", "datatype");
        String fieldName = xmlValueElement.getLocalName();
        Element parentXsComplexTypeElement = this.xsMeta.complexTypeFor(parentXsElementElement);
        Element parentXsSequenceElement = this.xsMeta.sequenceFor(parentXsComplexTypeElement);
        Element xsFieldElementElement = this.xsMeta.createXsElementElement(this.helper.docFor(parentXsSequenceElement), fieldName);
        parentXsSequenceElement.appendChild(xsFieldElementElement);
        Element xsFieldComplexTypeElement = this.xsMeta.complexTypeFor(xsFieldElementElement);
        Element xsFieldSequenceElement = this.xsMeta.sequenceFor(xsFieldComplexTypeElement);
        this.addXsElementForAppExtensions(xsFieldSequenceElement, extensions);
        this.xsMeta.addXsIsisFeatureAttributeElements(xsFieldComplexTypeElement, "value");
        this.xsMeta.addXsIsisAttribute(xsFieldComplexTypeElement, "datatype", datatype);
        this.xsMeta.addXsIsisAttribute(xsFieldComplexTypeElement, "isEmpty");
        this.xsMeta.addXsIsisAttribute(xsFieldComplexTypeElement, "annotation");
        return xsFieldElementElement;
    }

    private void addExtensionElements(Element parentElement, Hashtable extensions) {
        Enumeration e = extensions.keys();
        while (e.hasMoreElements()) {
            Class extensionClass = (Class)e.nextElement();
            Object extensionObject = extensions.get(extensionClass);
            Element xsExtensionElementElement = this.xsMeta.createXsElementElement(this.helper.docFor(parentElement), "x-" + this.shortName(extensionClass.getName()));
            xsExtensionElementElement.setAttribute("default", extensionObject.toString());
            xsExtensionElementElement.setAttribute("minOccurs", "0");
            parentElement.appendChild(xsExtensionElementElement);
        }
    }

    Element createXsElementForNofReference(Element parentXsElementElement, Element xmlReferenceElement, String referencedClassName, Hashtable extensions) {
        String fieldName = xmlReferenceElement.getLocalName();
        Element parentXsComplexTypeElement = this.xsMeta.complexTypeFor(parentXsElementElement);
        Element parentXsSequenceElement = this.xsMeta.sequenceFor(parentXsComplexTypeElement);
        Element xsFieldElementElement = this.xsMeta.createXsElementElement(this.helper.docFor(parentXsSequenceElement), fieldName);
        parentXsSequenceElement.appendChild(xsFieldElementElement);
        Element xsFieldComplexTypeElement = this.xsMeta.complexTypeFor(xsFieldElementElement);
        Element xsFieldSequenceElement = this.xsMeta.sequenceFor(xsFieldComplexTypeElement);
        Element xsFieldTitleElement = this.xsMeta.createXsElement(this.helper.docFor(xsFieldSequenceElement), "element");
        xsFieldTitleElement.setAttribute("ref", "isis:title");
        xsFieldSequenceElement.appendChild(xsFieldTitleElement);
        this.xsMeta.setXsCardinality(xsFieldTitleElement, 0, 1);
        this.addXsElementForAppExtensions(xsFieldSequenceElement, extensions);
        Element xsReferencedElementSequenceElement = this.xsMeta.sequenceFor(xsFieldSequenceElement);
        this.xsMeta.setXsCardinality(xsReferencedElementSequenceElement, 0, 1);
        this.xsMeta.addXsIsisFeatureAttributeElements(xsFieldComplexTypeElement, "reference");
        this.xsMeta.addXsIsisAttribute(xsFieldComplexTypeElement, "type", "app:" + referencedClassName, false);
        this.xsMeta.addXsIsisAttribute(xsFieldComplexTypeElement, "isEmpty");
        this.xsMeta.addXsIsisAttribute(xsFieldComplexTypeElement, "annotation");
        return xsFieldElementElement;
    }

    Element createXsElementForNofCollection(Element parentXsElementElement, Element xmlCollectionElement, String referencedClassName, Hashtable extensions) {
        String fieldName = xmlCollectionElement.getLocalName();
        Element parentXsComplexTypeElement = this.xsMeta.complexTypeFor(parentXsElementElement);
        Element parentXsSequenceElement = this.xsMeta.sequenceFor(parentXsComplexTypeElement);
        Element xsFieldElementElement = this.xsMeta.createXsElementElement(this.helper.docFor(parentXsSequenceElement), fieldName);
        parentXsSequenceElement.appendChild(xsFieldElementElement);
        Element xsFieldComplexTypeElement = this.xsMeta.complexTypeFor(xsFieldElementElement);
        Element xsFieldSequenceElement = this.xsMeta.sequenceFor(xsFieldComplexTypeElement);
        Element xsFieldOidsElement = this.xsMeta.createXsElement(this.helper.docFor(xsFieldSequenceElement), "element");
        xsFieldOidsElement.setAttribute("ref", "isis:oids");
        xsFieldSequenceElement.appendChild(xsFieldOidsElement);
        this.xsMeta.setXsCardinality(xsFieldOidsElement, 0, 1);
        this.addXsElementForAppExtensions(xsFieldSequenceElement, extensions);
        this.xsMeta.addXsIsisFeatureAttributeElements(xsFieldComplexTypeElement, "collection");
        this.xsMeta.addXsIsisAttribute(xsFieldComplexTypeElement, "type", "app:" + referencedClassName, false);
        this.xsMeta.addXsIsisAttribute(xsFieldComplexTypeElement, "size");
        this.xsMeta.addXsIsisAttribute(xsFieldComplexTypeElement, "annotation");
        return xsFieldElementElement;
    }

    void assignSchema(Document xmlDoc, String fullyQualifiedClassName, String schemaLocationFileName) {
        String xsiSchemaLocationAttrValue = this.getUri() + " " + schemaLocationFileName;
        Element rootElement = xmlDoc.getDocumentElement();
        this.addNamespace(rootElement, "xsi", "http://www.w3.org/2001/XMLSchema-instance");
        rootElement.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", xsiSchemaLocationAttrValue);
    }

    void addFieldXsElement(Element xsElement, Element xsFieldElement) {
        if (xsFieldElement == null) {
            return;
        }
        Element sequenceElement = this.xsMeta.sequenceForComplexTypeFor(xsElement);
        sequenceElement.appendChild(xsFieldElement);
    }

    private void addNamespace(Element element, String prefix, String nsUri) {
        Element rootElement = this.helper.rootElementFor(element);
        String existingNsUri = rootElement.getAttributeNS("http://www.w3.org/2000/xmlns/", prefix);
        if (existingNsUri == null || !existingNsUri.equals(nsUri)) {
            this.helper.rootElementFor(element).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, nsUri);
        }
    }

    Element addXsElementIfNotPresent(Element parentXsElement, Element childXsElement) {
        Element parentChoiceOrSequenceElement = this.xsMeta.choiceOrSequenceFor(this.xsMeta.complexTypeFor(parentXsElement));
        if (parentChoiceOrSequenceElement == null) {
            throw new IllegalArgumentException("Unable to locate complexType/sequence or complexType/choice under supplied parent XSD element");
        }
        NamedNodeMap childXsElementAttributeMap = childXsElement.getAttributes();
        Attr childXsElementAttr = (Attr)childXsElementAttributeMap.getNamedItem("name");
        String localName = childXsElementAttr.getValue();
        NodeList existingElements = parentChoiceOrSequenceElement.getElementsByTagNameNS("*", childXsElement.getLocalName());
        for (int i = 0; i < existingElements.getLength(); ++i) {
            Element xsElement = (Element)existingElements.item(i);
            NamedNodeMap xsElementAttributeMap = xsElement.getAttributes();
            Attr attr = (Attr)xsElementAttributeMap.getNamedItem("name");
            if (attr == null || !attr.getValue().equals(localName)) continue;
            return xsElement;
        }
        parentChoiceOrSequenceElement.appendChild(childXsElement);
        return childXsElement;
    }
}

