/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.webapp.content;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ResourceCachingFilter
implements Filter {
    private static final String REQUEST_ATTRIBUTE = ResourceCachingFilter.class.getName() + ".resource";
    private static final int MILLISECONDS_IN_SECOND = 1000;
    private static final String POST_CHECK_VALUE = "post-check=";
    private static final String PRE_CHECK_VALUE = "pre-check=";
    private static final String MAX_AGE_VALUE = "max-age=";
    private static final String ZERO_STRING_VALUE = "0";
    private static final String NO_STORE_VALUE = "no-store";
    private static final String NO_CACHE_VALUE = "no-cache";
    private static final String PRAGMA_HEADER = "Pragma";
    private static final String CACHE_CONTROL_HEADER = "Cache-Control";
    private static final String EXPIRES_HEADER = "Expires";
    private static final String LAST_MODIFIED_HEADER = "Last-Modified";
    private static final String CACHE_TIME_PARAM_NAME = "CacheTime";
    private static final String CACHE_TIME_PARAM_NAME_DEFAULT = "86400";
    private String[][] mReplyHeaders = new String[][]{new String[0]};
    private Long cacheTime = 0L;

    public static boolean isCachedResource(HttpServletRequest request) {
        return request.getAttribute(REQUEST_ATTRIBUTE) != null;
    }

    public void init(FilterConfig pConfig) {
        ArrayList<String[]> newReplyHeaders = new ArrayList<String[]>();
        String cacheTime = pConfig.getInitParameter(CACHE_TIME_PARAM_NAME);
        this.cacheTime = Long.parseLong(cacheTime != null ? cacheTime : CACHE_TIME_PARAM_NAME_DEFAULT);
        if (this.cacheTime > 0L) {
            newReplyHeaders.add(new String[]{CACHE_CONTROL_HEADER, MAX_AGE_VALUE + this.cacheTime});
            newReplyHeaders.add(new String[]{CACHE_CONTROL_HEADER, PRE_CHECK_VALUE + this.cacheTime});
            newReplyHeaders.add(new String[]{CACHE_CONTROL_HEADER, POST_CHECK_VALUE + this.cacheTime});
        } else {
            newReplyHeaders.add(new String[]{PRAGMA_HEADER, NO_CACHE_VALUE});
            newReplyHeaders.add(new String[]{EXPIRES_HEADER, ZERO_STRING_VALUE});
            newReplyHeaders.add(new String[]{CACHE_CONTROL_HEADER, NO_CACHE_VALUE});
            newReplyHeaders.add(new String[]{CACHE_CONTROL_HEADER, NO_STORE_VALUE});
        }
        this.mReplyHeaders = new String[newReplyHeaders.size()][2];
        newReplyHeaders.toArray((T[])this.mReplyHeaders);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpResponse = (HttpServletResponse)servletResponse;
        for (String[] replyHeader : this.mReplyHeaders) {
            String name = replyHeader[0];
            String value = replyHeader[1];
            httpResponse.addHeader(name, value);
        }
        if (this.cacheTime > 0L) {
            long now = System.currentTimeMillis();
            SimpleDateFormat httpDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
            httpDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            httpResponse.addHeader(LAST_MODIFIED_HEADER, httpDateFormat.format(new Date(now)));
            httpResponse.addHeader(EXPIRES_HEADER, httpDateFormat.format(new Date(now + this.cacheTime * 1000L)));
        }
        httpRequest.setAttribute(REQUEST_ATTRIBUTE, (Object)true);
        chain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }
}

