/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.webapp.diagnostics;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsisLogOnExceptionFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(IsisLogOnExceptionFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            chain.doFilter(request, response);
        }
        catch (IOException ex) {
            IsisLogOnExceptionFilter.logRequestUrl(request, ex);
            throw ex;
        }
        catch (ServletException ex) {
            IsisLogOnExceptionFilter.logRequestUrl(request, (Exception)((Object)ex));
            throw ex;
        }
        catch (RuntimeException ex) {
            IsisLogOnExceptionFilter.logRequestUrl(request, ex);
            throw ex;
        }
    }

    private static void logRequestUrl(ServletRequest request, Exception e) {
        if (!(request instanceof HttpServletRequest)) {
            return;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        StringBuffer buf = httpServletRequest.getRequestURL();
        String queryString = httpServletRequest.getQueryString();
        if (queryString != null) {
            buf.append('?').append(queryString);
        }
        LOG.error("Request caused " + e.getClass().getName() + ": " + buf.toString(), (Throwable)e);
    }
}

