/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.metamodel.facets.object.discriminator;

import com.google.common.base.Strings;
import javax.jdo.annotations.Discriminator;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.object.objectspecid.classname.ObjectSpecIdFacetDerivedFromClassName;
import org.apache.isis.core.metamodel.specloader.classsubstitutor.ClassSubstitutor;
import org.apache.isis.objectstore.jdo.metamodel.facets.object.discriminator.JdoDiscriminatorFacetDefault;
import org.apache.isis.objectstore.jdo.metamodel.facets.object.discriminator.ObjectSpecIdFacetInferredFromJdoDiscriminatorValueAnnotation;

public class JdoDiscriminatorAnnotationFacetFactory
extends FacetFactoryAbstract {
    private final ClassSubstitutor classSubstitutor = new ClassSubstitutor();

    public JdoDiscriminatorAnnotationFacetFactory() {
        super(FeatureType.OBJECTS_ONLY);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContext) {
        Discriminator annotation = Annotations.getAnnotation(processClassContext.getCls(), Discriminator.class);
        if (annotation == null) {
            return;
        }
        String annotationValueAttribute = annotation.value();
        if (!Strings.isNullOrEmpty((String)annotationValueAttribute)) {
            FacetUtil.addFacet(new ObjectSpecIdFacetInferredFromJdoDiscriminatorValueAnnotation(annotationValueAttribute, (FacetHolder)processClassContext.getFacetHolder()));
        } else {
            Object facetHolder = processClassContext.getFacetHolder();
            Class<?> originalClass = processClassContext.getCls();
            Class<?> substitutedClass = this.classSubstitutor.getClass(originalClass);
            FacetUtil.addFacet(new ObjectSpecIdFacetDerivedFromClassName(substitutedClass.getCanonicalName(), (FacetHolder)facetHolder));
        }
        FacetUtil.addFacet(new JdoDiscriminatorFacetDefault(annotationValueAttribute, (FacetHolder)processClassContext.getFacetHolder()));
    }
}

