/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.metamodel.facets.object.persistencecapable;

import com.google.common.base.Strings;
import javax.jdo.annotations.IdentityType;
import javax.jdo.annotations.PersistenceCapable;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.objectstore.jdo.metamodel.facets.object.persistencecapable.JdoPersistenceCapableFacetAnnotation;

public class JdoPersistenceCapableAnnotationFacetFactory
extends FacetFactoryAbstract {
    public JdoPersistenceCapableAnnotationFacetFactory() {
        super(FeatureType.OBJECTS_ONLY);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContext) {
        String annotationTableAttribute;
        Class<?> cls = processClassContext.getCls();
        PersistenceCapable annotation = Annotations.getAnnotation(cls, PersistenceCapable.class);
        if (annotation == null) {
            return;
        }
        String annotationSchemaAttribute = annotation.schema();
        if (Strings.isNullOrEmpty((String)annotationSchemaAttribute)) {
            annotationSchemaAttribute = null;
        }
        if (Strings.isNullOrEmpty((String)(annotationTableAttribute = annotation.table()))) {
            annotationTableAttribute = cls.getSimpleName();
        }
        IdentityType annotationIdentityType = annotation.identityType();
        FacetUtil.addFacet(new JdoPersistenceCapableFacetAnnotation(annotationSchemaAttribute, annotationTableAttribute, annotationIdentityType, (FacetHolder)processClassContext.getFacetHolder()));
    }
}

