/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.metamodel.specloader.validator;

import javax.jdo.annotations.IdentityType;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacet;
import org.apache.isis.core.metamodel.facets.object.parented.ParentedFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorVisiting;
import org.apache.isis.core.metamodel.specloader.validator.ValidationFailures;
import org.apache.isis.objectstore.jdo.metamodel.facets.object.persistencecapable.JdoPersistenceCapableFacet;

public class JdoMetaModelValidator
extends MetaModelValidatorComposite {
    public JdoMetaModelValidator() {
        this.addValidatorToEnsurePersistenceCapables();
        this.addValidatorToEnsureIdentityType();
        this.addValidatorToCheckForUnsupportedAnnotations();
    }

    private void addValidatorToEnsurePersistenceCapables() {
        MetaModelValidatorVisiting.SummarizingVisitor ensurePersistenceCapables = new MetaModelValidatorVisiting.SummarizingVisitor(){
            private boolean found = false;

            @Override
            public boolean visit(ObjectSpecification objectSpec, ValidationFailures validationFailures) {
                boolean containsFacet = objectSpec.containsFacet(JdoPersistenceCapableFacet.class);
                if (containsFacet) {
                    this.found = true;
                    return false;
                }
                return true;
            }

            @Override
            public void summarize(ValidationFailures validationFailures) {
                if (!this.found) {
                    validationFailures.add("No @PersistenceCapable entities found. (Are the entities referenced by the registered services? are all services registered? did the DataNucleus enhancer run?)", new Object[0]);
                }
            }
        };
        this.add(new MetaModelValidatorVisiting(ensurePersistenceCapables));
    }

    private void addValidatorToEnsureIdentityType() {
        MetaModelValidatorVisiting.Visitor ensureIdentityType = new MetaModelValidatorVisiting.Visitor(){

            @Override
            public boolean visit(ObjectSpecification objSpec, ValidationFailures validationFailures) {
                JdoPersistenceCapableFacet jpcf = objSpec.getFacet(JdoPersistenceCapableFacet.class);
                if (jpcf == null) {
                    return true;
                }
                IdentityType identityType = jpcf.getIdentityType();
                if (identityType != IdentityType.APPLICATION && identityType != IdentityType.NONDURABLE && identityType != IdentityType.DATASTORE && identityType != IdentityType.UNSPECIFIED) {
                    validationFailures.add("%s: is annotated with @PersistenceCapable but with an unrecognized identityType (%s)", objSpec.getFullIdentifier(), identityType);
                }
                return true;
            }
        };
        this.add(new MetaModelValidatorVisiting(ensureIdentityType));
    }

    private void addValidatorToCheckForUnsupportedAnnotations() {
        MetaModelValidatorVisiting.Visitor ensureIdentityType = new MetaModelValidatorVisiting.Visitor(){

            @Override
            public boolean visit(ObjectSpecification objSpec, ValidationFailures validationFailures) {
                if (objSpec.containsDoOpFacet(ParentedFacet.class) && !objSpec.containsDoOpFacet(CollectionFacet.class)) {
                    validationFailures.add("%s: DataNucleus object store currently does not supported Aggregated or EmbeddedOnly annotations", objSpec.getFullIdentifier());
                }
                return true;
            }
        };
        this.add(new MetaModelValidatorVisiting(ensureIdentityType));
    }
}

