/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime;

import org.apache.isis.core.commons.config.IsisConfiguration;

public enum PersistorImplementation {
    DATANUCLEUS,
    INMEMORY;


    public static PersistorImplementation from(IsisConfiguration configuration) {
        String persistor = configuration.getString("isis.persistor", "datanucleus");
        return "datanucleus".equalsIgnoreCase(persistor) ? DATANUCLEUS : INMEMORY;
    }

    public boolean isDataNucleus() {
        return this == DATANUCLEUS;
    }

    public boolean isInMemory() {
        return this == INMEMORY;
    }
}

