/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.memento;

import java.io.IOException;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.commons.encoding.DataInputExtended;
import org.apache.isis.core.commons.encoding.DataOutputExtended;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.runtime.memento.Data;

public class CollectionData
extends Data {
    private static final long serialVersionUID = 1L;
    final Data[] elements;

    public CollectionData(Oid oid, String className, Data[] elements) {
        super(oid, className);
        this.elements = elements;
        this.initialized();
    }

    public CollectionData(DataInputExtended input) throws IOException {
        super(input);
        this.elements = (Data[])input.readEncodables(Data.class);
        this.initialized();
    }

    @Override
    public void encode(DataOutputExtended output) throws IOException {
        super.encode(output);
        output.writeEncodables((Object[])this.elements);
    }

    public void initialized() {
    }

    @Override
    public void debug(DebugBuilder debug) {
        super.debug(debug);
        for (int i = 0; i < this.elements.length; ++i) {
            debug.appendln("" + i + 1, (Object)this.elements[i]);
        }
    }

    @Override
    public String toString() {
        StringBuffer str = new StringBuffer("(");
        for (int i = 0; i < this.elements.length; ++i) {
            str.append(i > 0 ? "," : "");
            str.append(this.elements[i]);
        }
        str.append(")");
        return str.toString();
    }
}

