/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.memento;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.commons.encoding.DataInputStreamExtended;
import org.apache.isis.core.commons.encoding.DataOutputStreamExtended;
import org.apache.isis.core.commons.ensure.Assert;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.exceptions.UnknownTypeException;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.oid.OidMarshaller;
import org.apache.isis.core.metamodel.adapter.oid.ParentedOid;
import org.apache.isis.core.metamodel.adapter.oid.TypedOid;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacet;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacetUtils;
import org.apache.isis.core.metamodel.facets.object.encodeable.EncodableFacet;
import org.apache.isis.core.metamodel.facets.propcoll.accessor.PropertyOrCollectionAccessorFacet;
import org.apache.isis.core.metamodel.facets.properties.update.modify.PropertySetterFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationLoaderSpi;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.core.runtime.memento.CollectionData;
import org.apache.isis.core.runtime.memento.Data;
import org.apache.isis.core.runtime.memento.ObjectData;
import org.apache.isis.core.runtime.memento.StandaloneData;
import org.apache.isis.core.runtime.persistence.PersistorUtil;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Memento
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(Memento.class);
    private final List<Oid> transientObjects = Lists.newArrayList();
    private Data data;

    public Memento(ObjectAdapter adapter) {
        Data data = this.data = adapter == null ? null : this.createData(adapter);
        if (LOG.isDebugEnabled()) {
            LOG.debug("created memento for " + this);
        }
    }

    private Data createData(ObjectAdapter adapter) {
        if (adapter.getSpecification().isParentedOrFreeCollection() && !adapter.getSpecification().isEncodeable()) {
            return this.createCollectionData(adapter);
        }
        return this.createObjectData(adapter);
    }

    private Data createCollectionData(ObjectAdapter adapter) {
        CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec((ObjectAdapter)adapter);
        Data[] collData = new Data[facet.size(adapter)];
        int i = 0;
        for (ObjectAdapter ref : facet.iterable(adapter)) {
            collData[i++] = this.createReferenceData(ref);
        }
        String elementTypeSpecName = adapter.getSpecification().getFullIdentifier();
        return new CollectionData(Memento.clone(adapter.getOid()), elementTypeSpecName, collData);
    }

    private ObjectData createObjectData(ObjectAdapter adapter) {
        Oid adapterOid = Memento.clone(adapter.getOid());
        this.transientObjects.add(adapterOid);
        ObjectSpecification cls = adapter.getSpecification();
        List associations = cls.getAssociations(Contributed.EXCLUDED);
        ObjectData data = new ObjectData(adapterOid, cls.getFullIdentifier());
        for (int i = 0; i < associations.size(); ++i) {
            if (((ObjectAssociation)associations.get(i)).isNotPersisted()) {
                if (((ObjectAssociation)associations.get(i)).isOneToManyAssociation()) continue;
                if (((ObjectAssociation)associations.get(i)).containsFacet(PropertyOrCollectionAccessorFacet.class) && !((ObjectAssociation)associations.get(i)).containsFacet(PropertySetterFacet.class)) {
                    LOG.debug("ignoring not-settable field " + ((ObjectAssociation)associations.get(i)).getName());
                    continue;
                }
            }
            this.createAssociationData(adapter, data, (ObjectAssociation)associations.get(i));
        }
        return data;
    }

    private void createAssociationData(ObjectAdapter adapter, ObjectData data, ObjectAssociation objectAssoc) {
        Object assocData;
        if (objectAssoc.isOneToManyAssociation()) {
            ObjectAdapter collAdapter = objectAssoc.get(adapter);
            assocData = this.createCollectionData(collAdapter);
        } else if (objectAssoc.getSpecification().isEncodeable()) {
            EncodableFacet facet = (EncodableFacet)objectAssoc.getSpecification().getFacet(EncodableFacet.class);
            ObjectAdapter value = objectAssoc.get(adapter);
            assocData = facet.toEncodedString(value);
        } else if (objectAssoc.isOneToOneAssociation()) {
            ObjectAdapter referencedAdapter = ((OneToOneAssociation)objectAssoc).get(adapter);
            assocData = this.createReferenceData(referencedAdapter);
        } else {
            throw new UnknownTypeException((Object)objectAssoc);
        }
        data.addField(objectAssoc.getId(), assocData);
    }

    private Data createReferenceData(ObjectAdapter referencedAdapter) {
        if (referencedAdapter == null) {
            return null;
        }
        Oid refOid = Memento.clone(referencedAdapter.getOid());
        if (refOid == null) {
            return this.createStandaloneData(referencedAdapter);
        }
        if ((referencedAdapter.getSpecification().isParented() || refOid.isTransient()) && !this.transientObjects.contains(refOid)) {
            this.transientObjects.add(refOid);
            return this.createObjectData(referencedAdapter);
        }
        String specification = referencedAdapter.getSpecification().getFullIdentifier();
        return new Data(refOid, specification);
    }

    private static <T extends Oid> T clone(T oid) {
        if (oid == null) {
            return null;
        }
        OidMarshaller oidMarshaller = new OidMarshaller();
        String oidStr = oid.enString(oidMarshaller);
        return (T)oidMarshaller.unmarshal(oidStr, oid.getClass());
    }

    private Data createStandaloneData(ObjectAdapter adapter) {
        return new StandaloneData(adapter);
    }

    public Oid getOid() {
        return this.data.getOid();
    }

    protected Data getData() {
        return this.data;
    }

    public ObjectAdapter recreateObject() {
        ObjectAdapter adapter;
        if (this.data == null) {
            return null;
        }
        ObjectSpecification spec = this.getSpecificationLoader().loadSpecification(this.data.getClassName());
        Oid oid = this.getOid();
        if (spec.isParentedOrFreeCollection()) {
            Object recreatedPojo = spec.createObject();
            adapter = this.getPersistenceSession().getAdapterManager().mapRecreatedPojo(oid, recreatedPojo);
            this.populateCollection(adapter, (CollectionData)this.data);
        } else {
            Assert.assertTrue((String)"oid must be a TypedOid representing an object because spec is not a collection and cannot be a value", (boolean)(oid instanceof TypedOid));
            TypedOid typedOid = (TypedOid)oid;
            adapter = this.getAdapterManager().getAdapterFor((Oid)typedOid);
            if (adapter != null) {
                this.getAdapterManager().removeAdapter(adapter);
            }
            adapter = this.getAdapterManager().adapterFor(typedOid);
            this.updateObject(adapter, this.data);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("recreated object " + adapter.getOid());
        }
        return adapter;
    }

    private void populateCollection(ObjectAdapter collectionAdapter, CollectionData state) {
        ObjectAdapter[] initData = new ObjectAdapter[state.elements.length];
        int i = 0;
        for (Data elementData : state.elements) {
            initData[i++] = this.recreateReference(elementData);
        }
        CollectionFacet facet = (CollectionFacet)collectionAdapter.getSpecification().getFacet(CollectionFacet.class);
        facet.init(collectionAdapter, initData);
    }

    private ObjectAdapter recreateReference(Data data) {
        if (data instanceof StandaloneData) {
            StandaloneData standaloneData = (StandaloneData)data;
            return standaloneData.getAdapter();
        }
        Oid oid = data.getOid();
        Assert.assertTrue((String)"can only create a reference to an entity", (boolean)(oid instanceof TypedOid));
        TypedOid typedOid = (TypedOid)oid;
        if (typedOid == null) {
            return null;
        }
        ObjectAdapter referencedAdapter = this.getAdapterManager().adapterFor(typedOid);
        if (data instanceof ObjectData) {
            if (typedOid instanceof ParentedOid) {
                this.updateObject(referencedAdapter, data);
            } else if (typedOid.isTransient()) {
                this.updateObject(referencedAdapter, data);
            }
        }
        return referencedAdapter;
    }

    private void updateObject(ObjectAdapter adapter, Data data) {
        Oid oid = adapter.getOid();
        if (oid != null && !oid.equals(data.getOid())) {
            throw new IllegalArgumentException("This memento can only be used to update the ObjectAdapter with the Oid " + data.getOid() + " but is " + oid);
        }
        if (!(data instanceof ObjectData)) {
            throw new IsisException("Expected an ObjectData but got " + data.getClass());
        }
        this.updateFieldsAndResolveState(adapter, data);
        if (LOG.isDebugEnabled()) {
            LOG.debug("object updated " + adapter.getOid());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFieldsAndResolveState(ObjectAdapter objectAdapter, Data data) {
        boolean dataIsTransient = data.getOid().isTransient();
        if (!dataIsTransient) {
            try {
                PersistorUtil.startResolvingOrUpdating(objectAdapter);
                this.updateFields(objectAdapter, data);
                objectAdapter.getOid().setVersion(data.getOid().getVersion());
            }
            finally {
                PersistorUtil.toEndState(objectAdapter);
            }
        } else if (objectAdapter.isTransient() && dataIsTransient) {
            this.updateFields(objectAdapter, data);
        } else if (objectAdapter.isParented()) {
            this.updateFields(objectAdapter, data);
        } else {
            ObjectData od = (ObjectData)data;
            if (od.containsField()) {
                throw new IsisException("Resolve state (for " + objectAdapter + ") inconsistent with fact that data exists for fields");
            }
        }
    }

    private void updateFields(ObjectAdapter object, Data state) {
        ObjectData od = (ObjectData)state;
        List fields = object.getSpecification().getAssociations(Contributed.EXCLUDED);
        for (ObjectAssociation field : fields) {
            if (field.isNotPersisted()) {
                if (field.isOneToManyAssociation()) continue;
                if (field.containsFacet(PropertyOrCollectionAccessorFacet.class) && !field.containsFacet(PropertySetterFacet.class)) {
                    LOG.debug("ignoring not-settable field " + field.getName());
                    continue;
                }
            }
            this.updateField(object, od, field);
        }
    }

    private void updateField(ObjectAdapter objectAdapter, ObjectData objectData, ObjectAssociation objectAssoc) {
        Object fieldData = objectData.getEntry(objectAssoc.getId());
        if (objectAssoc.isOneToManyAssociation()) {
            this.updateOneToManyAssociation(objectAdapter, (OneToManyAssociation)objectAssoc, (CollectionData)fieldData);
        } else if (objectAssoc.getSpecification().containsFacet(EncodableFacet.class)) {
            EncodableFacet facet = (EncodableFacet)objectAssoc.getSpecification().getFacet(EncodableFacet.class);
            ObjectAdapter value = facet.fromEncodedString((String)fieldData);
            ((OneToOneAssociation)objectAssoc).initAssociation(objectAdapter, value);
        } else if (objectAssoc.isOneToOneAssociation()) {
            this.updateOneToOneAssociation(objectAdapter, (OneToOneAssociation)objectAssoc, (Data)fieldData);
        }
    }

    private void updateOneToManyAssociation(ObjectAdapter objectAdapter, OneToManyAssociation otma, CollectionData collectionData) {
        ObjectAdapter collection = otma.get(objectAdapter);
        CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec((ObjectAdapter)collection);
        ArrayList original = Lists.newArrayList();
        for (ObjectAdapter adapter : facet.iterable(collection)) {
            original.add(adapter);
        }
        Data[] elements = collectionData.elements;
        for (Data data : elements) {
            ObjectAdapter elementAdapter = this.recreateReference(data);
            if (!facet.contains(collection, elementAdapter)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("  association " + otma + " changed, added " + elementAdapter.getOid());
                }
                otma.addElement(objectAdapter, elementAdapter);
                continue;
            }
            otma.removeElement(objectAdapter, elementAdapter);
        }
        for (ObjectAdapter element : original) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("  association " + otma + " changed, removed " + element.getOid());
            }
            otma.removeElement(objectAdapter, element);
        }
    }

    private void updateOneToOneAssociation(ObjectAdapter objectAdapter, OneToOneAssociation otoa, Data assocData) {
        if (assocData == null) {
            otoa.initAssociation(objectAdapter, null);
        } else {
            ObjectAdapter ref = this.recreateReference(assocData);
            if (otoa.get(objectAdapter) != ref) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("  association " + otoa + " changed to " + ref.getOid());
                }
                otoa.initAssociation(objectAdapter, ref);
            }
        }
    }

    public void encodedData(DataOutputStreamExtended outputImpl) throws IOException {
        outputImpl.writeEncodable((Object)this.data);
    }

    public void restore(DataInputStreamExtended input) throws IOException {
        this.data = (Data)input.readEncodable(Data.class);
    }

    public static Memento recreateFrom(DataInputStreamExtended input) throws IOException {
        Memento memento = new Memento(null);
        memento.restore(input);
        return memento;
    }

    public String toString() {
        return "[" + (this.data == null ? null : this.data.getClassName() + "/" + this.data.getOid() + this.data) + "]";
    }

    public void debug(DebugBuilder debug) {
        if (this.data != null) {
            this.data.debug(debug);
        }
    }

    protected SpecificationLoaderSpi getSpecificationLoader() {
        return IsisContext.getSpecificationLoader();
    }

    protected PersistenceSession getPersistenceSession() {
        return IsisContext.getPersistenceSession();
    }

    protected AdapterManager getAdapterManager() {
        return this.getPersistenceSession().getAdapterManager();
    }
}

