/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.persistence.objectstore.algorithm;

import java.util.List;
import org.apache.isis.core.commons.util.ToString;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ResolveState;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacet;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacetUtils;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.runtime.persistence.ObjectPersistenceException;
import org.apache.isis.core.runtime.persistence.objectstore.algorithm.PersistAlgorithmAbstract;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PersistAlgorithmDefault
extends PersistAlgorithmAbstract {
    private static final Logger LOG = LoggerFactory.getLogger(PersistAlgorithmDefault.class);

    PersistAlgorithmDefault() {
    }

    @Override
    public String name() {
        return "Simple Bottom Up Persistence Walker";
    }

    @Override
    public void makePersistent(ObjectAdapter adapter, PersistenceSession toPersistObjectSet) {
        if (adapter.getSpecification().isParentedOrFreeCollection()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("persist " + adapter);
            }
            if (adapter.isGhost()) {
                adapter.changeState(ResolveState.RESOLVING);
                adapter.changeState(ResolveState.RESOLVED);
            } else if (adapter.isTransient()) {
                adapter.changeState(ResolveState.RESOLVED);
            }
            CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec((ObjectAdapter)adapter);
            for (ObjectAdapter element : facet.iterable(adapter)) {
                this.persist(element, toPersistObjectSet);
            }
        } else {
            PersistAlgorithmDefault.assertObjectNotPersistentAndPersistable(adapter);
            this.persist(adapter, toPersistObjectSet);
        }
    }

    protected void persist(ObjectAdapter adapter, PersistenceSession toPersistObjectSet) {
        if (PersistAlgorithmDefault.alreadyPersistedOrNotPersistableOrServiceOrStandalone(adapter)) {
            return;
        }
        List associations = adapter.getSpecification().getAssociations(Contributed.EXCLUDED);
        if (!adapter.getSpecification().isEncodeable() && associations.size() > 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("make persistent " + adapter);
            }
            toPersistObjectSet.remapAsPersistent(adapter);
            ResolveState stateWhilePersisting = ResolveState.UPDATING;
            adapter.changeState(stateWhilePersisting);
            for (int i = 0; i < associations.size(); ++i) {
                ObjectAssociation objectAssoc = (ObjectAssociation)associations.get(i);
                if (objectAssoc.isNotPersisted()) continue;
                if (objectAssoc.isOneToManyAssociation()) {
                    ObjectAdapter collection = objectAssoc.get(adapter);
                    if (collection == null) {
                        throw new ObjectPersistenceException("Collection " + objectAssoc.getName() + " does not exist in " + adapter.getSpecification().getFullIdentifier());
                    }
                    this.makePersistent(collection, toPersistObjectSet);
                    continue;
                }
                ObjectAdapter fieldValue = objectAssoc.get(adapter);
                if (fieldValue == null) continue;
                this.persist(fieldValue, toPersistObjectSet);
            }
            toPersistObjectSet.addCreateObjectCommand(adapter);
            adapter.changeState(stateWhilePersisting.getEndState());
        }
    }

    public String toString() {
        ToString toString = new ToString((Object)this);
        return toString.toString();
    }
}

