/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.persistence.objectstore.algorithm;

import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.runtime.PersistorImplementation;
import org.apache.isis.core.runtime.persistence.objectstore.algorithm.PersistAlgorithm;
import org.apache.isis.core.runtime.persistence.objectstore.algorithm.PersistAlgorithmAbstract;
import org.apache.isis.core.runtime.persistence.objectstore.algorithm.PersistAlgorithmDefault;
import org.apache.isis.core.runtime.persistence.objectstore.algorithm.PersistAlgorithmForDataNucleus;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistAlgorithmUnified
extends PersistAlgorithmAbstract {
    private static final Logger LOG = LoggerFactory.getLogger(PersistAlgorithmUnified.class);
    private final PersistAlgorithm persistAlgorithm;

    public PersistAlgorithmUnified(IsisConfiguration configuration) {
        PersistorImplementation persistorImplementation = PersistorImplementation.from(configuration);
        this.persistAlgorithm = persistorImplementation.isDataNucleus() ? new PersistAlgorithmForDataNucleus() : new PersistAlgorithmDefault();
    }

    @Override
    public String name() {
        return "PersistAlgorithmUnified";
    }

    @Override
    public void makePersistent(ObjectAdapter adapter, PersistenceSession persistenceSession) {
        this.persistAlgorithm.makePersistent(adapter, persistenceSession);
    }

    public String toString() {
        return this.persistAlgorithm.toString();
    }
}

