/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.persistence.objectstore.transaction;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.isis.applib.annotation.PublishedAction;
import org.apache.isis.applib.annotation.PublishedObject;
import org.apache.isis.applib.services.publish.EventMetadata;
import org.apache.isis.applib.services.publish.EventPayload;
import org.apache.isis.applib.services.publish.ObjectStringifier;
import org.apache.isis.applib.services.publish.PublishingService;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facets.actions.action.invocation.ActionInvocationFacet;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;

public class PublishingServiceWithDefaultPayloadFactories {
    private final PublishingService publishingService;
    private final PublishedObject.PayloadFactory defaultObjectPayloadFactory;
    private final PublishedAction.PayloadFactory defaultActionPayloadFactory;
    private static final Function<ObjectAdapter, ObjectAdapter> NOT_DESTROYED_ELSE_EMPTY = new Function<ObjectAdapter, ObjectAdapter>(){

        public ObjectAdapter apply(ObjectAdapter adapter) {
            if (adapter == null) {
                return null;
            }
            if (!adapter.isDestroyed()) {
                return adapter;
            }
            Object replacementObject = adapter.getSpecification().createObject();
            this.getPersistenceSession().getAdapterManager().remapRecreatedPojo(adapter, replacementObject);
            return adapter;
        }

        protected PersistenceSession getPersistenceSession() {
            return IsisContext.getPersistenceSession();
        }
    };

    public PublishingServiceWithDefaultPayloadFactories(PublishingService publishingService, PublishedObject.PayloadFactory defaultObjectPayloadFactory, PublishedAction.PayloadFactory defaultActionPayloadFactory) {
        this.publishingService = publishingService;
        this.defaultObjectPayloadFactory = defaultObjectPayloadFactory;
        this.defaultActionPayloadFactory = defaultActionPayloadFactory;
    }

    public void publishObject(PublishedObject.PayloadFactory payloadFactoryIfAny, EventMetadata metadata, ObjectAdapter changedAdapter, PublishedObject.ChangeKind changeKind, ObjectStringifier stringifier) {
        PublishedObject.PayloadFactory payloadFactoryToUse = payloadFactoryIfAny != null ? payloadFactoryIfAny : this.defaultObjectPayloadFactory;
        EventPayload payload = payloadFactoryToUse.payloadFor(ObjectAdapter.Util.unwrap((ObjectAdapter)PublishingServiceWithDefaultPayloadFactories.undeletedElseEmpty(changedAdapter)), changeKind);
        payload.withStringifier(stringifier);
        this.publishingService.publish(metadata, payload);
    }

    public void publishAction(PublishedAction.PayloadFactory payloadFactoryIfAny, EventMetadata metadata, ActionInvocationFacet.CurrentInvocation currentInvocation, ObjectStringifier stringifier) {
        PublishedAction.PayloadFactory payloadFactoryToUse = payloadFactoryIfAny != null ? payloadFactoryIfAny : this.defaultActionPayloadFactory;
        ObjectAdapter target = currentInvocation.getTarget();
        ObjectAdapter result = currentInvocation.getResult();
        List parameters = currentInvocation.getParameters();
        EventPayload payload = payloadFactoryToUse.payloadFor(currentInvocation.getAction().getIdentifier(), ObjectAdapter.Util.unwrap((ObjectAdapter)PublishingServiceWithDefaultPayloadFactories.undeletedElseEmpty(target)), ObjectAdapter.Util.unwrap(PublishingServiceWithDefaultPayloadFactories.undeletedElseEmpty(parameters)), ObjectAdapter.Util.unwrap((ObjectAdapter)PublishingServiceWithDefaultPayloadFactories.undeletedElseEmpty(result)));
        payload.withStringifier(stringifier);
        this.publishingService.publish(metadata, payload);
    }

    private static List<ObjectAdapter> undeletedElseEmpty(List<ObjectAdapter> parameters) {
        return Lists.newArrayList((Iterable)Iterables.transform(parameters, NOT_DESTROYED_ELSE_EMPTY));
    }

    private static ObjectAdapter undeletedElseEmpty(ObjectAdapter adapter) {
        return (ObjectAdapter)NOT_DESTROYED_ELSE_EMPTY.apply((Object)adapter);
    }
}

