/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.progmodels;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetdecorator.FacetDecorator;
import org.apache.isis.core.metamodel.specloader.FacetDecoratorInstaller;
import org.apache.isis.core.runtime.installerregistry.InstallerLookup;
import org.apache.isis.core.runtime.installerregistry.InstallerLookupAware;
import org.apache.isis.progmodels.dflt.JavaReflectorInstallerNoDecorators;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaReflectorInstaller
extends JavaReflectorInstallerNoDecorators
implements InstallerLookupAware {
    private static final Logger LOG = LoggerFactory.getLogger(JavaReflectorInstaller.class);
    private InstallerLookup installerLookup;

    protected Set<FacetDecorator> createFacetDecorators(IsisConfiguration configuration) {
        this.addFacetDecoratorInstallers(configuration);
        return this.createFacetDecorators(this.decoratorInstallers);
    }

    private void addFacetDecoratorInstallers(IsisConfiguration configuration) {
        String[] decoratorNames;
        for (String decoratorName : decoratorNames = configuration.getList("isis.reflector.facet-decorators")) {
            if (LOG.isInfoEnabled()) {
                LOG.info("adding reflector facet decorator from configuration " + decoratorName);
            }
            this.addFacetDecoratorInstaller(this.lookupFacetDecorator(decoratorName));
        }
    }

    private FacetDecoratorInstaller lookupFacetDecorator(String decoratorClassName) {
        return this.installerLookup.getInstaller(FacetDecoratorInstaller.class, decoratorClassName);
    }

    private Set<FacetDecorator> createFacetDecorators(Set<FacetDecoratorInstaller> decoratorInstallers) {
        LinkedHashSet decorators = new LinkedHashSet();
        if (decoratorInstallers.size() == 0 && LOG.isInfoEnabled()) {
            LOG.info("No facet decorators installers added");
        }
        for (FacetDecoratorInstaller installer : decoratorInstallers) {
            decorators.addAll(installer.createDecorators());
        }
        return Collections.unmodifiableSet(decorators);
    }

    @Override
    public void setInstallerLookup(InstallerLookup installerLookup) {
        this.installerLookup = installerLookup;
    }
}

