/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.runner.opts;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.isis.core.commons.config.IsisConfigurationBuilder;
import org.apache.isis.core.runtime.optionhandler.BootPrinter;
import org.apache.isis.core.runtime.optionhandler.OptionHandlerAbstract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptionHandlerAppManifest
extends OptionHandlerAbstract {
    private static final Logger LOG = LoggerFactory.getLogger(OptionHandlerAppManifest.class);
    private String appManifestClassName;

    public void addOption(Options options) {
        OptionBuilder.withArgName((String)"app manifest");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"manifest");
        OptionBuilder.withDescription((String)"fully qualified AppManifest class");
        Option option = OptionBuilder.create((String)"m");
        options.addOption(option);
    }

    public boolean handle(CommandLine commandLine, BootPrinter bootPrinter, Options options) {
        this.appManifestClassName = commandLine.getOptionValue("m");
        return true;
    }

    public void primeConfigurationBuilder(IsisConfigurationBuilder isisConfigurationBuilder) {
        if (this.appManifestClassName == null) {
            return;
        }
        OptionHandlerAppManifest.prime(isisConfigurationBuilder, "isis.appManifest", this.appManifestClassName);
    }

    static void prime(IsisConfigurationBuilder isisConfigurationBuilder, String key, String value) {
        LOG.info("priming: " + key + "=" + value);
        isisConfigurationBuilder.add(key, value);
    }
}

