/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.isis.core.runtime.services.MapEntry;

class Parsed<V>
implements Comparable<Parsed<V>> {
    private static final Function<String, Integer> PARSE = new Function<String, Integer>(){

        public Integer apply(String input) {
            try {
                return Integer.parseInt(input);
            }
            catch (NumberFormatException e) {
                return Integer.MAX_VALUE;
            }
        }
    };
    private final List<Integer> parts;
    private final String key;
    private final V value;

    Parsed(Map.Entry<String, V> entry) {
        this.key = entry.getKey();
        this.value = entry.getValue();
        Iterable iter = Splitter.on((String)".").split((CharSequence)entry.getKey());
        this.parts = Lists.newArrayList((Iterator)Iterators.transform(iter.iterator(), PARSE));
    }

    @Override
    public int compareTo(Parsed<V> other) {
        for (int i = 0; i < this.parts.size(); ++i) {
            Integer p = this.parts.get(i);
            if (other.parts.size() < this.parts.size()) {
                return -1;
            }
            Integer q = other.parts.get(i);
            int comparison = p.compareTo(q);
            if (comparison == 0) continue;
            return comparison;
        }
        if (other.parts.size() > this.parts.size()) {
            return 1;
        }
        return 0;
    }

    public Map.Entry<String, V> toMapEntry() {
        return new MapEntry<String, V>(this.key, this.value){};
    }
}

