/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import javax.annotation.PreDestroy;
import org.apache.isis.applib.AppManifest;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.DomainServiceLayout;
import org.apache.isis.applib.services.classdiscovery.ClassDiscoveryServiceUsingReflections;
import org.apache.isis.core.runtime.services.DeweyOrderComparator;
import org.apache.isis.core.runtime.services.ServiceInstantiator;
import org.apache.isis.core.runtime.services.ServicesInstallerAbstract;
import org.apache.isis.core.runtime.services.ServicesInstallerUtils;
import org.reflections.Reflections;
import org.reflections.vfs.Vfs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServicesInstallerFromAnnotation
extends ServicesInstallerAbstract {
    private static final Logger LOG = LoggerFactory.getLogger(ServicesInstallerFromAnnotation.class);
    public static final String NAME = "annotation";
    public static final String PACKAGE_PREFIX_KEY = "isis.services.ServicesInstallerFromAnnotation.packagePrefix";
    public static final String PACKAGE_PREFIX_STANDARD = Joiner.on((String)",").join((Iterable)AppManifest.Registry.FRAMEWORK_PROVIDED_SERVICES);
    private final ServiceInstantiator serviceInstantiator;
    private String packagePrefixes;
    private boolean initialized = false;
    private List<Object> serviceList;

    public ServicesInstallerFromAnnotation() {
        this(new ServiceInstantiator());
    }

    public ServicesInstallerFromAnnotation(ServiceInstantiator serviceInstantiator) {
        super(NAME);
        this.serviceInstantiator = serviceInstantiator;
    }

    public void withPackagePrefixes(String ... packagePrefixes) {
        this.packagePrefixes = Joiner.on((String)",").join((Object[])packagePrefixes);
    }

    @Override
    public void setIgnoreFailures(boolean ignoreFailures) {
    }

    public void init() {
        this.initIfRequired();
    }

    protected void initIfRequired() {
        if (this.initialized) {
            return;
        }
        if (this.getConfiguration() == null) {
            throw new IllegalStateException("No IsisConfiguration injected - aborting");
        }
        try {
            this.serviceInstantiator.setConfiguration(this.getConfiguration());
            if (this.packagePrefixes == null) {
                this.packagePrefixes = PACKAGE_PREFIX_STANDARD;
                String packagePrefixes = this.getConfiguration().getString(PACKAGE_PREFIX_KEY);
                if (!Strings.isNullOrEmpty((String)packagePrefixes)) {
                    this.packagePrefixes = this.packagePrefixes + "," + packagePrefixes;
                }
            }
        }
        finally {
            this.initialized = true;
        }
    }

    @PreDestroy
    public void shutdown() {
    }

    private Predicate<Class<?>> instantiatable() {
        return Predicates.and((Predicate)Predicates.not(ServicesInstallerFromAnnotation.nullClass()), (Predicate)Predicates.not(ServicesInstallerFromAnnotation.abstractClass()));
    }

    private static Function<String, String> trim() {
        return new Function<String, String>(){

            public String apply(String input) {
                return input.trim();
            }
        };
    }

    private static Predicate<Class<?>> nullClass() {
        return new Predicate<Class<?>>(){

            public boolean apply(Class<?> input) {
                return input == null;
            }
        };
    }

    private static Predicate<Class<?>> abstractClass() {
        return new Predicate<Class<?>>(){

            public boolean apply(Class<?> input) {
                return Modifier.isAbstract(input.getModifiers());
            }
        };
    }

    @Override
    public List<Object> getServices() {
        this.initIfRequired();
        if (this.serviceList == null) {
            TreeMap positionedServices = Maps.newTreeMap((Comparator)new DeweyOrderComparator());
            this.appendServices(positionedServices);
            this.serviceList = ServicesInstallerUtils.instantiateServicesFrom(positionedServices, this.serviceInstantiator);
        }
        return this.serviceList;
    }

    public void appendServices(SortedMap<String, SortedSet<String>> positionedServices) {
        this.initIfRequired();
        List<String> packagePrefixList = this.asList(this.packagePrefixes);
        Set domainServiceTypes = AppManifest.Registry.instance().getDomainServiceTypes();
        if (domainServiceTypes == null) {
            Vfs.setDefaultURLTypes((List)ClassDiscoveryServiceUsingReflections.getUrlTypes());
            Reflections reflections = new Reflections(new Object[]{packagePrefixList});
            domainServiceTypes = reflections.getTypesAnnotatedWith(DomainService.class);
        }
        ArrayList domainServiceClasses = Lists.newArrayList((Iterable)Iterables.filter((Iterable)domainServiceTypes, this.instantiatable()));
        for (Class cls : domainServiceClasses) {
            String order = ServicesInstallerFromAnnotation.orderOf(cls);
            String fullyQualifiedClassName = cls.getName();
            String name = ServicesInstallerFromAnnotation.nameOf(cls);
            ServicesInstallerUtils.appendInPosition(positionedServices, order, fullyQualifiedClassName);
        }
    }

    private static String orderOf(Class<?> cls) {
        String order;
        DomainServiceLayout domainServiceLayout = cls.getAnnotation(DomainServiceLayout.class);
        String string = order = domainServiceLayout != null ? domainServiceLayout.menuOrder() : null;
        if (order == null || order.equals("2147483647")) {
            DomainService domainService = cls.getAnnotation(DomainService.class);
            order = domainService != null ? domainService.menuOrder() : "2147483647";
        }
        return order;
    }

    private static String nameOf(Class<?> cls) {
        String name;
        DomainServiceLayout domainServiceLayout = cls.getAnnotation(DomainServiceLayout.class);
        String string = name = domainServiceLayout != null ? domainServiceLayout.named() : null;
        if (name == null) {
            name = cls.getName();
        }
        return name;
    }

    protected List<String> asList(String csv) {
        return Lists.newArrayList((Iterable)Iterables.transform((Iterable)Splitter.on((String)",").split((CharSequence)csv), ServicesInstallerFromAnnotation.trim()));
    }

    public List<Class<?>> getTypes() {
        return ServicesInstallerFromAnnotation.listOf((Class[])new Class[]{List.class});
    }
}

