/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import org.apache.isis.core.runtime.services.ServiceInstantiator;
import org.apache.isis.core.runtime.services.ServicesInstallerFromConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ServicesInstallerUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ServicesInstallerFromConfiguration.class);
    private static final char DELIMITER = '#';

    private ServicesInstallerUtils() {
    }

    static <V extends Comparable<V>> LinkedHashSet<V> flatten(SortedMap<String, SortedSet<V>> positionedServices) {
        LinkedHashSet serviceList = Sets.newLinkedHashSet();
        Set<String> keys = positionedServices.keySet();
        for (String position : keys) {
            SortedSet list = (SortedSet)positionedServices.get(position);
            serviceList.addAll(list);
        }
        return serviceList;
    }

    static <V> void appendInPosition(SortedMap<String, SortedSet<String>> positionedServices, String position, String service) {
        if (service == null) {
            return;
        }
        SortedSet serviceList = (SortedSet)positionedServices.get(position);
        if (serviceList == null) {
            serviceList = Sets.newTreeSet();
            positionedServices.put(position, serviceList);
        }
        serviceList.add(service);
    }

    static Object instantiateService(String serviceName, ServiceInstantiator serviceInstantiator) {
        int pos = serviceName.indexOf(35);
        if (pos == 0) {
            return null;
        }
        String type = pos != -1 ? serviceName.substring(0, pos) : serviceName;
        return serviceInstantiator.createInstance(type);
    }

    static List<Object> instantiateServicesFrom(SortedMap<String, SortedSet<String>> positionedServices, ServiceInstantiator serviceInstantiator) {
        LinkedHashSet serviceNameList = ServicesInstallerUtils.flatten(positionedServices);
        Collection filter = Collections2.filter((Collection)Collections2.transform(serviceNameList, ServicesInstallerUtils.instantiator(serviceInstantiator)), (Predicate)Predicates.notNull());
        return Lists.newArrayList((Iterable)filter);
    }

    private static Function<String, Object> instantiator(final ServiceInstantiator serviceInstantiator) {
        return new Function<String, Object>(){

            public Object apply(String serviceName) {
                return ServicesInstallerUtils.instantiateService(serviceName, serviceInstantiator);
            }
        };
    }
}

