/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.eventbus.adapter;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.isis.core.runtime.services.eventbus.EventBusImplementationAbstract;
import org.axonframework.domain.EventMessage;
import org.axonframework.domain.GenericEventMessage;
import org.axonframework.eventhandling.EventListener;
import org.axonframework.eventhandling.SimpleEventBus;
import org.axonframework.eventhandling.annotation.AnnotationEventListenerAdapter;

public class EventBusImplementationForAxonSimple
extends EventBusImplementationAbstract {
    private static SimpleEventBus simpleEventBus = new SimpleEventBus();
    private static Map<Object, AxonEventListenerAdapter> adapters = Maps.newConcurrentMap();

    private static AxonEventListenerAdapter adapterFor(Object domainService) {
        AxonEventListenerAdapter annotationEventListenerAdapter = adapters.get(domainService);
        if (annotationEventListenerAdapter == null) {
            annotationEventListenerAdapter = new AxonEventListenerAdapter(domainService);
            adapters.put(domainService, annotationEventListenerAdapter);
        }
        return annotationEventListenerAdapter;
    }

    public void register(Object domainService) {
        simpleEventBus.subscribe((EventListener)EventBusImplementationForAxonSimple.adapterFor(domainService));
    }

    public void unregister(Object domainService) {
    }

    public void post(Object event) {
        simpleEventBus.publish(new EventMessage[]{GenericEventMessage.asEventMessage((Object)event)});
    }

    static class AxonEventListenerAdapter
    extends AnnotationEventListenerAdapter {
        public AxonEventListenerAdapter(Object annotatedEventListener) {
            super(annotatedEventListener);
        }

        public void handle(EventMessage event) {
            try {
                super.handle(event);
            }
            catch (Exception exception) {
                EventBusImplementationForAxonSimple.processException(exception, event);
            }
        }
    }
}

