/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.i18n.po;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.SortedMap;
import java.util.SortedSet;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.apache.isis.core.runtime.services.i18n.po.PoAbstract;
import org.apache.isis.core.runtime.services.i18n.po.TranslationServicePo;
import org.joda.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PoWriter
extends PoAbstract {
    public static Logger LOG = LoggerFactory.getLogger(PoWriter.class);
    private final SortedMap<String, Block> blocksByMsgId = Maps.newTreeMap();

    public PoWriter(TranslationServicePo translationServicePo) {
        super(translationServicePo, TranslationService.Mode.WRITE);
    }

    @Override
    void shutdown() {
        StringBuilder buf = new StringBuilder();
        buf.append("\n");
        buf.append("\n##############################################################################");
        buf.append("\n#");
        buf.append("\n# .pot file");
        buf.append("\n#");
        buf.append("\n# generated at: ").append(LocalDateTime.now().toString("yyyy-MM-dd HH:mm:ss"));
        buf.append("\n# generated by: ").append(TranslationServicePo.class.getSimpleName());
        buf.append("\n#");
        buf.append("\n# Translate this file to each required language and place in WEB-INF, eg:");
        buf.append("\n#");
        buf.append("\n#     /WEB-INF/translations-en_US.po");
        buf.append("\n#     /WEB-INF/translations-en.po");
        buf.append("\n#     /WEB-INF/translations-fr_FR.po");
        buf.append("\n#     /WEB-INF/translations-fr.po");
        buf.append("\n#     /WEB-INF/translations.po");
        buf.append("\n#");
        buf.append("\n# If the app uses TranslatableString (eg for internationalized validation");
        buf.append("\n# messages), or if the app calls the TranslationService directly, then ensure");
        buf.append("\n# that all text to be translated has been captured by running a full");
        buf.append("\n# integration test suite that exercises all relevant behaviour");
        buf.append("\n#");
        buf.append("\n##############################################################################");
        buf.append("\n");
        buf.append("\n");
        buf.append(this.toPot());
        buf.append("\n");
        buf.append("\n");
        buf.append("\n##############################################################################");
        buf.append("\n# end of .pot file");
        buf.append("\n##############################################################################");
        buf.append("\n");
        LOG.info(buf.toString());
    }

    @Override
    public String translate(String context, String msgId) {
        Block block = this.blockFor(msgId);
        block.contexts.add(context);
        return msgId;
    }

    @Override
    String translate(String context, String msgId, String msgIdPlural, int num) {
        Block block = this.blockFor(msgId);
        block.contexts.add(context);
        block.msgIdPlural = msgIdPlural;
        return null;
    }

    private Block blockFor(String msgId) {
        Block block = (Block)this.blocksByMsgId.get(msgId);
        if (block == null) {
            block = new Block(msgId);
            this.blocksByMsgId.put(msgId, block);
        }
        return block;
    }

    String toPot() {
        StringBuilder buf = new StringBuilder();
        for (String msgId : this.blocksByMsgId.keySet()) {
            Block block = (Block)this.blocksByMsgId.get(msgId);
            for (String context : block.contexts) {
                buf.append("#: ").append(context).append("\n");
            }
            buf.append("msgid \"").append(msgId).append("\"\n");
            if (block.msgIdPlural == null) {
                buf.append("msgstr \"\"\n");
            } else {
                buf.append("msgid_plural \"").append(block.msgIdPlural).append("\"\n");
                buf.append("msgstr[0] \"\"\n");
                buf.append("msgstr[1] \"\"\n");
            }
            buf.append("\n\n");
        }
        return buf.toString();
    }

    private static class Block {
        private final String msgId;
        private final SortedSet<String> contexts = Sets.newTreeSet();
        private String msgIdPlural;

        private Block(String msgId) {
            this.msgId = msgId;
        }
    }
}

