/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.sudo;

import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.isis.applib.DomainObjectContainer;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.sudo.SudoService;
import org.apache.isis.core.metamodel.services.container.DomainObjectContainerDefault;

@DomainService(nature=NatureOfService.DOMAIN)
public class SudoServiceDefault
implements SudoService {
    private DomainObjectContainerDefault containerDefault;
    @Inject
    private DomainObjectContainer container;

    @Programmatic
    @PostConstruct
    public void init() {
        if (this.container instanceof DomainObjectContainerDefault) {
            this.containerDefault = (DomainObjectContainerDefault)this.container;
        }
    }

    @Programmatic
    public void sudo(String user, Runnable runnable) {
        this.ensureContainerOk();
        try {
            this.containerDefault.overrideUser(user);
            runnable.run();
        }
        finally {
            this.containerDefault.resetOverrides();
        }
    }

    @Programmatic
    public <T> T sudo(String user, Callable<T> callable) {
        this.ensureContainerOk();
        try {
            this.containerDefault.overrideUser(user);
            T t = callable.call();
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.containerDefault.resetOverrides();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Programmatic
    public void sudo(String username, List<String> roles, Runnable runnable) {
        this.ensureContainerOk();
        try {
            this.containerDefault.overrideUserAndRoles(username, roles);
            runnable.run();
        }
        finally {
            this.containerDefault.resetOverrides();
        }
    }

    @Programmatic
    public <T> T sudo(String username, List<String> roles, Callable<T> callable) {
        this.ensureContainerOk();
        try {
            this.containerDefault.overrideUserAndRoles(username, roles);
            T t = callable.call();
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.containerDefault.resetOverrides();
        }
    }

    private void ensureContainerOk() {
        if (this.containerDefault == null) {
            throw new IllegalStateException("DomainObjectContainer does not support the user being overridden");
        }
    }
}

