/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.isis.applib.DomainObjectContainer;
import org.apache.isis.applib.fixtures.LogonFixture;
import org.apache.isis.applib.fixturescripts.FixtureScripts;
import org.apache.isis.applib.services.fixturespec.FixtureScriptsDefault;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.components.ApplicationScopedComponent;
import org.apache.isis.core.commons.components.Noop;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.debug.DebuggableWithTitle;
import org.apache.isis.core.commons.lang.ListExtensions;
import org.apache.isis.core.metamodel.facetapi.MetaModelRefiner;
import org.apache.isis.core.metamodel.services.ServicesInjectorDefault;
import org.apache.isis.core.metamodel.services.ServicesInjectorSpi;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationLoaderSpi;
import org.apache.isis.core.metamodel.specloader.ServiceInitializer;
import org.apache.isis.core.runtime.authentication.AuthenticationManager;
import org.apache.isis.core.runtime.authorization.AuthorizationManager;
import org.apache.isis.core.runtime.fixtures.FixturesInstaller;
import org.apache.isis.core.runtime.persistence.internal.RuntimeContextFromSession;
import org.apache.isis.core.runtime.system.DebugSelection;
import org.apache.isis.core.runtime.system.DeploymentType;
import org.apache.isis.core.runtime.system.IsisSystemException;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.internal.InitialisationSession;
import org.apache.isis.core.runtime.system.internal.IsisLocaleInitializer;
import org.apache.isis.core.runtime.system.internal.IsisTimeZoneInitializer;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.persistence.PersistenceSessionFactory;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionManager;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionManagerException;
import org.apache.isis.core.runtime.systemusinginstallers.IsisComponentProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsisSystem
implements DebugSelection,
ApplicationScopedComponent {
    public static final Logger LOG = LoggerFactory.getLogger(IsisSystem.class);
    private final IsisLocaleInitializer localeInitializer;
    private final IsisTimeZoneInitializer timeZoneInitializer;
    private final DeploymentType deploymentType;
    private boolean initialized = false;
    private ServiceInitializer serviceInitializer;
    private FixturesInstaller fixtureInstaller;
    private IsisSessionFactory sessionFactory;
    private final IsisComponentProvider isisComponentProvider;
    private LogonFixture logonFixture;

    public IsisSystem(IsisComponentProvider isisComponentProvider) {
        this.deploymentType = isisComponentProvider.getDeploymentType();
        this.localeInitializer = new IsisLocaleInitializer();
        this.timeZoneInitializer = new IsisTimeZoneInitializer();
        this.isisComponentProvider = isisComponentProvider;
    }

    public DeploymentType getDeploymentType() {
        return this.deploymentType;
    }

    public IsisSessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void init() {
        if (this.initialized) {
            throw new IllegalStateException("Already initialized");
        }
        this.initialized = true;
        LOG.info("initialising Isis System");
        LOG.info("working directory: " + new File(".").getAbsolutePath());
        LOG.info("resource stream source: " + this.getConfiguration().getResourceStreamSource());
        this.localeInitializer.initLocale(this.getConfiguration());
        this.timeZoneInitializer.initTimeZone(this.getConfiguration());
        try {
            this.sessionFactory = this.createSessionFactory(this.deploymentType);
            IsisContext.setConfiguration(this.getConfiguration());
            this.initContext(this.sessionFactory);
            this.sessionFactory.init();
            SpecificationLoaderSpi specificationLoader = this.sessionFactory.getSpecificationLoader();
            specificationLoader.validateAndAssert();
            this.serviceInitializer = this.initializeServices();
            this.installFixturesIfRequired();
            this.translateServicesAndEnumConstants();
        }
        catch (IsisSystemException ex) {
            LOG.error("failed to initialise", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    private IsisSessionFactory createSessionFactory(DeploymentType deploymentType) throws IsisSystemException {
        IsisConfiguration configuration = this.isisComponentProvider.getConfiguration();
        List<Object> services = this.isisComponentProvider.provideServices();
        ServicesInjectorDefault servicesInjectorSpi = new ServicesInjectorDefault(services);
        servicesInjectorSpi.addFallbackIfRequired(FixtureScripts.class, (Object)new FixtureScriptsDefault());
        servicesInjectorSpi.validateServices();
        RuntimeContextFromSession runtimeContext = new RuntimeContextFromSession(configuration);
        PersistenceSessionFactory persistenceSessionFactory = this.isisComponentProvider.providePersistenceSessionFactory(deploymentType, (ServicesInjectorSpi)servicesInjectorSpi, runtimeContext);
        AuthenticationManager authenticationManager = this.isisComponentProvider.provideAuthenticationManager(deploymentType);
        AuthorizationManager authorizationManager = this.isisComponentProvider.provideAuthorizationManager(deploymentType);
        Collection<MetaModelRefiner> metaModelRefiners = IsisSystem.refiners(authenticationManager, authorizationManager, persistenceSessionFactory);
        SpecificationLoaderSpi reflector = this.isisComponentProvider.provideSpecificationLoaderSpi(metaModelRefiners);
        runtimeContext.injectInto(reflector);
        return new IsisSessionFactory(deploymentType, configuration, reflector, authenticationManager, authorizationManager, persistenceSessionFactory);
    }

    private static Collection<MetaModelRefiner> refiners(Object ... possibleRefiners) {
        return ListExtensions.filtered(Arrays.asList(possibleRefiners), MetaModelRefiner.class);
    }

    private void initContext(IsisSessionFactory sessionFactory) {
        this.getDeploymentType().initContext(sessionFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private ServiceInitializer initializeServices() {
        List<Object> services = this.sessionFactory.getServices();
        ServiceInitializer serviceInitializer = new ServiceInitializer();
        serviceInitializer.validate(this.getConfiguration(), services);
        IsisContext.openSession((AuthenticationSession)new InitialisationSession());
        try {
            ServiceInitializer serviceInitializer2;
            this.getTransactionManager().startTransaction();
            try {
                serviceInitializer.postConstruct();
                serviceInitializer2 = serviceInitializer;
            }
            catch (RuntimeException ex) {
                this.getTransactionManager().getTransaction().setAbortCause(new IsisTransactionManagerException(ex));
                ServiceInitializer serviceInitializer3 = serviceInitializer;
                this.getTransactionManager().endTransaction();
                IsisContext.closeSession();
                return serviceInitializer3;
                {
                    catch (Throwable throwable) {
                        this.getTransactionManager().endTransaction();
                        throw throwable;
                    }
                }
            }
            this.getTransactionManager().endTransaction();
            return serviceInitializer2;
        }
        finally {
            IsisContext.closeSession();
        }
    }

    private void installFixturesIfRequired() throws IsisSystemException {
        this.fixtureInstaller = this.isisComponentProvider.provideFixturesInstaller();
        if (this.isNoop(this.fixtureInstaller)) {
            return;
        }
        IsisContext.openSession((AuthenticationSession)new InitialisationSession());
        this.fixtureInstaller.installFixtures();
        try {
            if (!this.getDeploymentType().isProduction()) {
                this.logonFixture = this.fixtureInstaller.getLogonFixture();
            }
        }
        finally {
            IsisContext.closeSession();
        }
    }

    private boolean isNoop(FixturesInstaller candidate) {
        return candidate == null || this.fixtureInstaller instanceof Noop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void translateServicesAndEnumConstants() {
        IsisContext.openSession((AuthenticationSession)new InitialisationSession());
        try {
            List<Object> services = this.sessionFactory.getServices();
            DomainObjectContainer container = this.lookupService(DomainObjectContainer.class);
            for (Object service : services) {
                String string = container.titleOf(service);
            }
            for (ObjectSpecification objSpec : this.allSpecifications()) {
                T[] enumConstants;
                Class correspondingClass = objSpec.getCorrespondingClass();
                if (!correspondingClass.isEnum()) continue;
                for (Object enumConstant : enumConstants = correspondingClass.getEnumConstants()) {
                    String string = container.titleOf(enumConstant);
                }
            }
        }
        finally {
            IsisContext.closeSession();
        }
    }

    private <T> T lookupService(Class<T> serviceClass) {
        return (T)this.getServicesInjector().lookupService(serviceClass);
    }

    private ServicesInjectorSpi getServicesInjector() {
        return this.getPersistenceSession().getServicesInjector();
    }

    private PersistenceSession getPersistenceSession() {
        return IsisContext.getPersistenceSession();
    }

    Collection<ObjectSpecification> allSpecifications() {
        return IsisContext.getSpecificationLoader().allSpecifications();
    }

    public void shutdown() {
        LOG.info("shutting down system");
        this.shutdownServices(this.serviceInitializer);
        IsisContext.closeAllSessions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownServices(ServiceInitializer serviceInitializer) {
        IsisContext.openSession((AuthenticationSession)new InitialisationSession());
        try {
            this.getTransactionManager().startTransaction();
            try {
                serviceInitializer.preDestroy();
            }
            catch (RuntimeException ex) {
                this.getTransactionManager().getTransaction().setAbortCause(new IsisTransactionManagerException(ex));
            }
            finally {
                this.getTransactionManager().endTransaction();
            }
        }
        finally {
            IsisContext.closeSession();
        }
    }

    public IsisConfiguration getConfiguration() {
        return this.isisComponentProvider.getConfiguration();
    }

    public LogonFixture getLogonFixture() {
        return this.logonFixture;
    }

    @Override
    public DebuggableWithTitle debugSection(String selectionName) {
        if (selectionName.equals("Configuration")) {
            return this.getConfiguration();
        }
        return null;
    }

    @Override
    public String[] debugSectionNames() {
        String[] general = new String[]{"Overview", "Authenticator", "Configuration", "Reflector", "Requests", "Contexts"};
        String[] contextIds = IsisContext.getInstance().allSessionIds();
        String[] combined = new String[general.length + contextIds.length];
        System.arraycopy(general, 0, combined, 0, general.length);
        System.arraycopy(contextIds, 0, combined, general.length, contextIds.length);
        return combined;
    }

    IsisTransactionManager getTransactionManager() {
        return IsisContext.getTransactionManager();
    }
}

