/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.context;

import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.commons.debug.DebuggableWithTitle;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.session.IsisSession;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;

public class IsisContextStatic
extends IsisContext {
    private IsisSession session;

    public static IsisContext createInstance(IsisSessionFactory sessionFactory) {
        return new IsisContextStatic(IsisContext.ContextReplacePolicy.NOT_REPLACEABLE, IsisContext.SessionClosePolicy.EXPLICIT_CLOSE, sessionFactory);
    }

    public static IsisContext createRelaxedInstance(IsisSessionFactory sessionFactory) {
        return new IsisContextStatic(IsisContext.ContextReplacePolicy.REPLACEABLE, IsisContext.SessionClosePolicy.AUTO_CLOSE, sessionFactory);
    }

    protected IsisContextStatic(IsisContext.ContextReplacePolicy replacePolicy, IsisContext.SessionClosePolicy sessionClosePolicy, IsisSessionFactory sessionFactory) {
        super(replacePolicy, sessionClosePolicy, sessionFactory);
    }

    @Override
    public IsisSession getSessionInstance() {
        return this.session;
    }

    @Override
    public IsisSession openSessionInstance(AuthenticationSession authenticationSession) {
        this.applySessionClosePolicy();
        this.session = this.getSessionFactoryInstance().openSession(authenticationSession);
        this.session.open();
        return this.session;
    }

    @Override
    public void doClose() {
        this.session = null;
    }

    @Override
    protected IsisSession getSessionInstance(String sessionId) {
        return this.getSessionInstance();
    }

    @Override
    public String[] allSessionIds() {
        return new String[]{this.getSessionInstance().getId()};
    }

    @Override
    public void closeAllSessionsInstance() {
        IsisSession sessionInstance = this.getSessionInstance();
        if (sessionInstance != null) {
            sessionInstance.closeAll();
        }
    }

    public String debugTitle() {
        return "Static Context";
    }

    public void debug(DebugBuilder debug) {
        debug.appendAsHexln("hash", (long)this.hashCode());
        this.session.debugState(debug);
    }

    public void debugAll(DebugBuilder debug) {
        this.debug(debug);
        debug.appendln();
        this.debug(debug, IsisContextStatic.getPersistenceSession());
    }

    private void debug(DebugBuilder debug, Object object) {
        if (object instanceof DebuggableWithTitle) {
            DebuggableWithTitle d = (DebuggableWithTitle)object;
            debug.appendTitle(d.debugTitle());
            d.debugData(debug);
        } else {
            debug.appendln("no debug for " + object);
        }
    }
}

