/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.context;

import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.session.IsisSession;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsisContextThreadLocal
extends IsisContext {
    private static final Logger LOG = LoggerFactory.getLogger(IsisContextThreadLocal.class);
    private final Map<Thread, IsisSession> sessionsByThread = new IdentityHashMap<Thread, IsisSession>();

    public static IsisContext createInstance(IsisSessionFactory sessionFactory) {
        return new IsisContextThreadLocal(sessionFactory);
    }

    protected IsisContextThreadLocal(IsisSessionFactory sessionFactory) {
        this(IsisContext.ContextReplacePolicy.NOT_REPLACEABLE, IsisContext.SessionClosePolicy.AUTO_CLOSE, sessionFactory);
    }

    protected IsisContextThreadLocal(IsisContext.ContextReplacePolicy contextReplacePolicy, IsisContext.SessionClosePolicy sessionClosePolicy, IsisSessionFactory sessionFactory) {
        super(contextReplacePolicy, sessionClosePolicy, sessionFactory);
    }

    @Override
    public void closeAllSessionsInstance() {
        this.shutdownAllThreads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdownAllThreads() {
        Map<Thread, IsisSession> map = this.sessionsByThread;
        synchronized (map) {
            for (Map.Entry<Thread, IsisSession> entry : this.sessionsByThread.entrySet()) {
                LOG.info("Shutting down thread: {}", (Object)entry.getKey().getName());
                IsisSession data = entry.getValue();
                data.closeAll();
            }
        }
    }

    @Override
    protected void doClose() {
        this.sessionsByThread.remove(Thread.currentThread());
    }

    @Override
    public String[] allSessionIds() {
        String[] ids = new String[this.sessionsByThread.size()];
        int i = 0;
        for (IsisSession data : this.sessionsByThread.values()) {
            ids[i++] = data.getId();
        }
        return ids;
    }

    public String debugTitle() {
        return "Isis (by thread) " + Thread.currentThread().getName();
    }

    @Override
    public void debugData(DebugBuilder debug) {
        super.debugData(debug);
        debug.appendTitle("Threads based Contexts");
        for (Map.Entry<Thread, IsisSession> entry : this.sessionsByThread.entrySet()) {
            Thread thread = entry.getKey();
            IsisSession data = entry.getValue();
            debug.appendln(thread.toString(), (Object)data);
        }
    }

    @Override
    protected IsisSession getSessionInstance(String executionContextId) {
        for (IsisSession data : this.sessionsByThread.values()) {
            if (!data.getId().equals(executionContextId)) continue;
            return data;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IsisSession openSessionInstance(AuthenticationSession authenticationSession) {
        Thread thread = Thread.currentThread();
        Map<Thread, IsisSession> map = this.sessionsByThread;
        synchronized (map) {
            this.applySessionClosePolicy();
            IsisSession session = this.getSessionFactoryInstance().openSession(authenticationSession);
            if (LOG.isDebugEnabled()) {
                LOG.debug("  opening session " + session + " (count " + this.sessionsByThread.size() + ") for " + authenticationSession.getUserName());
            }
            this.saveSession(thread, session);
            session.open();
            return session;
        }
    }

    protected IsisSession createAndOpenSession(Thread thread, AuthenticationSession authenticationSession) {
        IsisSession session = this.getSessionFactoryInstance().openSession(authenticationSession);
        session.open();
        if (LOG.isInfoEnabled()) {
            LOG.info("  opening session " + session + " (count " + this.sessionsByThread.size() + ") for " + authenticationSession.getUserName());
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IsisSession saveSession(Thread thread, IsisSession session) {
        Map<Thread, IsisSession> map = this.sessionsByThread;
        synchronized (map) {
            this.sessionsByThread.put(thread, session);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("  saving session " + session + "; now have " + this.sessionsByThread.size() + " sessions");
        }
        return session;
    }

    @Override
    public IsisSession getSessionInstance() {
        Thread thread = Thread.currentThread();
        return this.sessionsByThread.get(thread);
    }
}

