/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.persistence;

import java.lang.reflect.Modifier;
import org.apache.isis.core.metamodel.services.ServicesInjectorSpi;
import org.apache.isis.core.metamodel.spec.ObjectInstantiationException;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;

public class ObjectFactory {
    private final Mode mode;

    public ObjectFactory() {
        this(Mode.STRICT);
    }

    public ObjectFactory(Mode mode) {
        this.mode = mode;
    }

    public <T> T instantiate(Class<T> cls) throws ObjectInstantiationException {
        if (this.mode == Mode.STRICT && this.getServicesInjector() == null) {
            throw new IllegalStateException("ServicesInjector is not available (no open session)");
        }
        if (Modifier.isAbstract(cls.getModifiers())) {
            throw new ObjectInstantiationException("Cannot create an instance of an abstract class: " + cls);
        }
        T newInstance = this.doInstantiate(cls);
        if (this.getServicesInjector() != null) {
            this.getServicesInjector().injectServicesInto(newInstance);
        }
        return newInstance;
    }

    protected <T> T doInstantiate(Class<T> cls) throws ObjectInstantiationException {
        if (Modifier.isAbstract(cls.getModifiers())) {
            throw new ObjectInstantiationException("Cannot create an instance of an abstract class: " + cls);
        }
        try {
            return cls.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ObjectInstantiationException((Throwable)e);
        }
    }

    private PersistenceSession getPersistenceSession() {
        return IsisContext.getPersistenceSession();
    }

    protected ServicesInjectorSpi getServicesInjector() {
        return this.getPersistenceSession().getServicesInjector();
    }

    public static enum Mode {
        STRICT,
        RELAXED;

    }
}

