/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.session;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.components.SessionScopedComponent;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.commons.debug.DebugString;
import org.apache.isis.core.commons.debug.DebuggableWithTitle;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.commons.util.ToString;
import org.apache.isis.core.metamodel.spec.SpecificationLoaderSpi;
import org.apache.isis.core.runtime.system.DeploymentType;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.core.runtime.system.transaction.IsisTransaction;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionManager;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsisSession
implements SessionScopedComponent {
    private static final Logger LOG = LoggerFactory.getLogger(IsisSession.class);
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd/MM HH:mm:ss,SSS");
    private static int nextId = 1;
    private final IsisSessionFactory isisSessionFactory;
    private final AuthenticationSession authenticationSession;
    private PersistenceSession persistenceSession;
    private final int id;
    private long accessTime;
    private String debugSnapshot;

    public IsisSession(IsisSessionFactory sessionFactory, AuthenticationSession authenticationSession, PersistenceSession persistenceSession) {
        Ensure.ensureThatArg((Object)sessionFactory, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"execution context factory is required");
        Ensure.ensureThatArg((Object)authenticationSession, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"authentication session is required");
        Ensure.ensureThatArg((Object)persistenceSession, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"persistence session is required");
        this.isisSessionFactory = sessionFactory;
        this.authenticationSession = authenticationSession;
        this.persistenceSession = persistenceSession;
        this.setSessionOpenTime(System.currentTimeMillis());
        this.id = nextId++;
    }

    public void open() {
        this.persistenceSession.open();
    }

    public void close() {
        try {
            this.takeSnapshot();
        }
        catch (Throwable ex) {
            LOG.error("Failed to takeSnapshot while closing the session; continuing to avoid memory leakage");
        }
        PersistenceSession persistenceSession = this.getPersistenceSession();
        if (persistenceSession != null) {
            persistenceSession.close();
        }
    }

    public void closeAll() {
        this.close();
        this.shutdownIfRequired(this.persistenceSession);
    }

    private void shutdownIfRequired(Object o) {
        if (o instanceof SessionScopedComponent) {
            SessionScopedComponent requiresSetup = (SessionScopedComponent)o;
            requiresSetup.close();
        }
    }

    public DeploymentType getDeploymentType() {
        return this.isisSessionFactory.getDeploymentType();
    }

    public IsisConfiguration getConfiguration() {
        return this.isisSessionFactory.getConfiguration();
    }

    public SpecificationLoaderSpi getSpecificationLoader() {
        return this.isisSessionFactory.getSpecificationLoader();
    }

    public AuthenticationSession getAuthenticationSession() {
        return this.authenticationSession;
    }

    private String getSessionUserName() {
        return this.getAuthenticationSession().getUserName();
    }

    public String getId() {
        return "#" + this.id + this.getSessionUserName();
    }

    public PersistenceSession getPersistenceSession() {
        return this.persistenceSession;
    }

    protected long getSessionOpenTime() {
        return this.accessTime;
    }

    private void setSessionOpenTime(long accessTime) {
        this.accessTime = accessTime;
    }

    public IsisTransaction getCurrentTransaction() {
        return this.getTransactionManager().getTransaction();
    }

    public String toString() {
        ToString asString = new ToString((Object)this);
        asString.append("context", this.getId());
        this.appendState(asString);
        return asString.toString();
    }

    public void debug(DebugBuilder debug) {
        debug.appendAsHexln("hash", (long)this.hashCode());
        debug.appendln("context id", (long)this.id);
        debug.appendln("accessed", (Object)DATE_FORMAT.format(new Date(this.getSessionOpenTime())));
        this.debugState(debug);
    }

    public void takeSnapshot() {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        DebugString debug = new DebugString();
        this.debug((DebugBuilder)debug);
        debug.indent();
        debug.appendln();
        this.debug((DebugBuilder)debug, this.getPersistenceSession());
        if (this.getCurrentTransaction() != null) {
            this.debug((DebugBuilder)debug, this.getCurrentTransaction().getMessageBroker());
        }
        this.debugSnapshot = debug.toString();
        LOG.debug(this.debugSnapshot);
    }

    private void debug(DebugBuilder debug, Object object) {
        if (object instanceof DebuggableWithTitle) {
            DebuggableWithTitle d = (DebuggableWithTitle)object;
            debug.startSection(d.debugTitle());
            d.debugData(debug);
            debug.endSection();
        } else {
            debug.appendln("no debug for " + object);
        }
    }

    public void appendState(ToString asString) {
        asString.append("authenticationSession", (Object)this.getAuthenticationSession());
        asString.append("persistenceSession", (Object)this.getPersistenceSession());
        asString.append("transaction", (Object)this.getCurrentTransaction());
    }

    public void debugState(DebugBuilder debug) {
        debug.appendln("authenticationSession", (Object)this.getAuthenticationSession());
        debug.appendln("persistenceSession", (Object)this.getPersistenceSession());
        debug.appendln("transaction", (Object)this.getCurrentTransaction());
    }

    private IsisTransactionManager getTransactionManager() {
        return this.getPersistenceSession().getTransactionManager();
    }
}

