/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.transaction.facets;

import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.DecoratingFacet;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionClearFacet;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionClearFacetAbstract;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionManager;
import org.apache.isis.core.runtime.system.transaction.TransactionalClosureAbstract;

public class CollectionClearFacetWrapTransaction
extends CollectionClearFacetAbstract
implements DecoratingFacet<CollectionClearFacet> {
    private final CollectionClearFacet underlyingFacet;

    public CollectionClearFacet getDecoratedFacet() {
        return this.underlyingFacet;
    }

    public CollectionClearFacetWrapTransaction(CollectionClearFacet underlyingFacet) {
        super(underlyingFacet.getFacetHolder());
        this.underlyingFacet = underlyingFacet;
    }

    public void clear(final ObjectAdapter adapter) {
        if (adapter.isTransient()) {
            this.underlyingFacet.clear(adapter);
        } else {
            CollectionClearFacetWrapTransaction.getTransactionManager().executeWithinTransaction(new TransactionalClosureAbstract(){

                @Override
                public void execute() {
                    CollectionClearFacetWrapTransaction.this.underlyingFacet.clear(adapter);
                }
            });
        }
    }

    public String toString() {
        return super.toString() + " --> " + this.underlyingFacet.toString();
    }

    private static IsisTransactionManager getTransactionManager() {
        return CollectionClearFacetWrapTransaction.getPersistenceSession().getTransactionManager();
    }

    private static PersistenceSession getPersistenceSession() {
        return IsisContext.getPersistenceSession();
    }
}

