/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.webapp;

import com.google.common.collect.Lists;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.isis.core.commons.config.IsisConfigurationBuilder;
import org.apache.isis.core.commons.config.IsisConfigurationBuilderPrimer;
import org.apache.isis.core.commons.config.IsisConfigurationBuilderResourceStreams;
import org.apache.isis.core.commons.config.NotFoundPolicy;
import org.apache.isis.core.commons.resource.ResourceStreamSource;
import org.apache.isis.core.commons.resource.ResourceStreamSourceComposite;
import org.apache.isis.core.commons.resource.ResourceStreamSourceContextLoaderClassPath;
import org.apache.isis.core.commons.resource.ResourceStreamSourceFileSystem;
import org.apache.isis.core.runtime.installerregistry.InstallerLookup;
import org.apache.isis.core.runtime.logging.IsisLoggingConfigurer;
import org.apache.isis.core.runtime.runner.IsisInjectModule;
import org.apache.isis.core.runtime.runner.opts.OptionHandlerInitParameters;
import org.apache.isis.core.runtime.system.DeploymentType;
import org.apache.isis.core.runtime.system.IsisSystem;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.webapp.IsisWebAppBootstrapperUtil;
import org.apache.isis.core.webapp.WebAppConstants;
import org.apache.isis.core.webapp.config.ResourceStreamSourceForWebInf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsisWebAppBootstrapper
implements ServletContextListener {
    private static final Logger LOG = LoggerFactory.getLogger(IsisWebAppBootstrapper.class);
    private final IsisLoggingConfigurer loggingConfigurer = new IsisLoggingConfigurer();
    private Injector injector;

    public static IsisSystem getSystemBoundTo(ServletContext servletContext) {
        Object system = servletContext.getAttribute(WebAppConstants.ISIS_SYSTEM_KEY);
        return (IsisSystem)system;
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        try {
            ServletContext servletContext = servletContextEvent.getServletContext();
            String webappDir = servletContext.getRealPath("/");
            String webInfDir = servletContext.getRealPath("/WEB-INF");
            this.loggingConfigurer.configureLogging(webInfDir, new String[0]);
            String configLocation = servletContext.getInitParameter("isis.config.dir");
            ResourceStreamSourceComposite compositeSource = new ResourceStreamSourceComposite(new ResourceStreamSource[]{ResourceStreamSourceContextLoaderClassPath.create(), new ResourceStreamSourceForWebInf(servletContext)});
            if (configLocation != null) {
                LOG.info("Config override location: " + configLocation);
                compositeSource.addResourceStreamSource(ResourceStreamSourceFileSystem.create((String)configLocation));
            } else {
                LOG.info("Config override location: No override location configured");
            }
            IsisConfigurationBuilderResourceStreams isisConfigurationBuilder = new IsisConfigurationBuilderResourceStreams((ResourceStreamSource)compositeSource);
            IsisWebAppBootstrapper.primeConfigurationBuilder((IsisConfigurationBuilder)isisConfigurationBuilder, servletContext);
            isisConfigurationBuilder.addDefaultConfigurationResources();
            DeploymentType deploymentType = this.determineDeploymentType((IsisConfigurationBuilder)isisConfigurationBuilder, servletContext);
            this.addConfigurationResourcesForWebApps((IsisConfigurationBuilder)isisConfigurationBuilder);
            this.addConfigurationResourcesForDeploymentType((IsisConfigurationBuilder)isisConfigurationBuilder, deploymentType);
            IsisWebAppBootstrapperUtil.addConfigurationResourcesForViewers((IsisConfigurationBuilder)isisConfigurationBuilder, servletContext);
            isisConfigurationBuilder.add("application.webapp.dir", webappDir);
            isisConfigurationBuilder.add("isis.nosplash", "true");
            InstallerLookup installerLookup = new InstallerLookup();
            this.injector = this.createGuiceInjector((IsisConfigurationBuilder)isisConfigurationBuilder, deploymentType, installerLookup);
            IsisSystem system = (IsisSystem)this.injector.getInstance(IsisSystem.class);
            isisConfigurationBuilder.lockConfiguration();
            isisConfigurationBuilder.dumpResourcesToLog();
            servletContext.setAttribute(WebAppConstants.ISIS_SYSTEM_KEY, (Object)system);
        }
        catch (RuntimeException e) {
            LOG.error("startup failed", (Throwable)e);
            throw e;
        }
        LOG.info("server started");
    }

    private Injector createGuiceInjector(IsisConfigurationBuilder isisConfigurationBuilder, DeploymentType deploymentType, InstallerLookup installerLookup) {
        IsisInjectModule isisModule = new IsisInjectModule(deploymentType, isisConfigurationBuilder, installerLookup);
        return Guice.createInjector((Module[])new Module[]{isisModule});
    }

    private static void primeConfigurationBuilder(IsisConfigurationBuilder isisConfigurationBuilder, ServletContext servletContext) {
        LOG.info("loading properties from option handlers");
        ArrayList isisConfigurationBuilderPrimers = Lists.newArrayList();
        List primers = (List)servletContext.getAttribute("isis.configurationPrimers");
        if (primers != null) {
            isisConfigurationBuilderPrimers.addAll(primers);
        }
        isisConfigurationBuilderPrimers.add(new OptionHandlerInitParameters(servletContext));
        for (IsisConfigurationBuilderPrimer isisConfigurationBuilderPrimer : isisConfigurationBuilderPrimers) {
            LOG.debug("priming configurations for " + isisConfigurationBuilderPrimer);
            isisConfigurationBuilderPrimer.primeConfigurationBuilder(isisConfigurationBuilder);
        }
    }

    private DeploymentType determineDeploymentType(IsisConfigurationBuilder isisConfigurationBuilder, ServletContext servletContext) {
        String deploymentTypeStr = null;
        deploymentTypeStr = servletContext.getInitParameter("deploymentType");
        if (deploymentTypeStr == null) {
            deploymentTypeStr = servletContext.getInitParameter("isis.deploymentType");
        }
        if (deploymentTypeStr == null) {
            deploymentTypeStr = isisConfigurationBuilder.getConfiguration().getString("isis.deploymentType");
        }
        if (deploymentTypeStr == null) {
            deploymentTypeStr = WebAppConstants.DEPLOYMENT_TYPE_DEFAULT;
        }
        return DeploymentType.lookup(deploymentTypeStr);
    }

    private void addConfigurationResourcesForDeploymentType(IsisConfigurationBuilder configurationLoader, DeploymentType deploymentType) {
        String type = deploymentType.name().toLowerCase();
        configurationLoader.addConfigurationResource(type + ".properties", NotFoundPolicy.CONTINUE);
    }

    private void addConfigurationResourcesForWebApps(IsisConfigurationBuilder configurationLoader) {
        for (String config : new String[]{"web.properties", "war.properties"}) {
            if (config == null) continue;
            configurationLoader.addConfigurationResource(config, NotFoundPolicy.CONTINUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextDestroyed(ServletContextEvent ev) {
        LOG.info("server shutting down");
        ServletContext servletContext = ev.getServletContext();
        try {
            IsisSystem system = (IsisSystem)servletContext.getAttribute(WebAppConstants.ISIS_SYSTEM_KEY);
            if (system != null) {
                LOG.info("calling system shutdown");
                system.shutdown();
                IsisContext.shutdown();
            }
        }
        finally {
            servletContext.removeAttribute(WebAppConstants.ISIS_SYSTEM_KEY);
            LOG.info("server shut down");
        }
    }
}

