/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.webapp;

import javax.servlet.ServletContext;
import org.apache.isis.core.commons.config.IsisConfigurationBuilder;
import org.apache.isis.core.commons.config.NotFoundPolicy;

public final class IsisWebAppBootstrapperUtil {
    private IsisWebAppBootstrapperUtil() {
    }

    public static void addConfigurationResourcesForViewers(IsisConfigurationBuilder configurationLoader, ServletContext servletContext) {
        IsisWebAppBootstrapperUtil.addConfigurationResourcesForContextParam(configurationLoader, servletContext, "isis.viewers");
        IsisWebAppBootstrapperUtil.addConfigurationResourcesForContextParam(configurationLoader, servletContext, "isis.viewer");
    }

    private static void addConfigurationResourcesForContextParam(IsisConfigurationBuilder configurationLoader, ServletContext servletContext, String name) {
        String viewers = servletContext.getInitParameter(name);
        if (viewers == null) {
            return;
        }
        for (String viewer : viewers.split(",")) {
            configurationLoader.addConfigurationResource("viewer_" + viewer + ".properties", NotFoundPolicy.CONTINUE);
        }
    }
}

