/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.datanucleus;

import com.google.common.base.Strings;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import javax.jdo.PersistenceManagerFactory;
import org.apache.isis.objectstore.jdo.datanucleus.DataNucleusPersistenceMechanismInstaller;
import org.apache.isis.objectstore.jdo.datanucleus.DataNucleusPropertiesAware;
import org.apache.isis.objectstore.jdo.datanucleus.PersistenceManagerFactoryAware;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.MetaDataListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateSchemaObjectFromClassMetadata
implements MetaDataListener,
PersistenceManagerFactoryAware,
DataNucleusPropertiesAware {
    private static final Logger LOG = LoggerFactory.getLogger(DataNucleusPersistenceMechanismInstaller.class);
    private PersistenceManagerFactory persistenceManagerFactory;
    private Map<String, String> properties;

    protected PersistenceManagerFactory getPersistenceManagerFactory() {
        return this.persistenceManagerFactory;
    }

    protected Map<String, String> getProperties() {
        return this.properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loaded(AbstractClassMetaData cmd) {
        Statement statement;
        Connection connection;
        block6: {
            String schemaName = cmd.getSchema();
            if (Strings.isNullOrEmpty((String)schemaName)) {
                return;
            }
            connection = null;
            statement = null;
            String driverName = this.properties.get("javax.jdo.option.ConnectionDriverName");
            String url = this.properties.get("javax.jdo.option.ConnectionURL");
            String userName = this.properties.get("javax.jdo.option.ConnectionUserName");
            String password = this.properties.get("javax.jdo.option.ConnectionPassword");
            connection = DriverManager.getConnection(url, userName, password);
            statement = connection.createStatement();
            if (!this.skip(cmd, statement)) break block6;
            this.closeSafely(statement);
            this.closeSafely(connection);
            return;
        }
        try {
            this.exec(cmd, statement);
            this.closeSafely(statement);
            this.closeSafely(connection);
        }
        catch (SQLException e) {
            try {
                LOG.warn("Unable to create schema", (Throwable)e);
                this.closeSafely(statement);
                this.closeSafely(connection);
            }
            catch (Throwable throwable) {
                this.closeSafely(statement);
                this.closeSafely(connection);
                throw throwable;
            }
        }
    }

    protected boolean skip(AbstractClassMetaData cmd, Statement statement) throws SQLException {
        String schemaName = cmd.getSchema();
        if (Strings.isNullOrEmpty((String)schemaName)) {
            return true;
        }
        String sql = this.buildSqlToCheck(cmd);
        try (ResultSet rs = statement.executeQuery(sql);){
            rs.next();
            int cnt = rs.getInt(1);
            boolean bl = cnt > 0;
            return bl;
        }
    }

    protected String buildSqlToCheck(AbstractClassMetaData cmd) {
        String schemaName = this.schemaNameFor(cmd);
        return String.format("SELECT count(*) FROM INFORMATION_SCHEMA.SCHEMATA where SCHEMA_NAME = '%s'", schemaName);
    }

    protected boolean exec(AbstractClassMetaData cmd, Statement statement) throws SQLException {
        String sql = this.buildSqlToExec(cmd);
        return statement.execute(sql);
    }

    protected String buildSqlToExec(AbstractClassMetaData cmd) {
        String schemaName = this.schemaNameFor(cmd);
        return String.format("CREATE SCHEMA \"%s\"", schemaName);
    }

    protected String schemaNameFor(AbstractClassMetaData cmd) {
        String schemaName = cmd.getSchema();
        String url = this.getProperties().get("javax.jdo.option.ConnectionURL");
        if (url.contains("postgres")) {
            // empty if block
        }
        if (url.contains("hsqldb")) {
            // empty if block
        }
        if (url.contains("sqlserver")) {
            // empty if block
        }
        return schemaName;
    }

    protected void closeSafely(AutoCloseable connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void setPersistenceManagerFactory(PersistenceManagerFactory persistenceManagerFactory) {
        this.persistenceManagerFactory = persistenceManagerFactory;
    }

    @Override
    public void setDataNucleusProperties(Map<String, String> properties) {
        this.properties = properties;
    }
}

