/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.datanucleus;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.isis.core.commons.config.InstallerAbstract;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.progmodel.ProgrammingModel;
import org.apache.isis.core.metamodel.services.ServicesInjectorSpi;
import org.apache.isis.core.metamodel.spec.SpecificationLoaderSpi;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidator;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.runtime.installerregistry.installerapi.PersistenceMechanismInstaller;
import org.apache.isis.core.runtime.persistence.internal.RuntimeContextFromSession;
import org.apache.isis.core.runtime.system.DeploymentType;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.ObjectStore;
import org.apache.isis.core.runtime.system.persistence.PersistenceSessionFactory;
import org.apache.isis.objectstore.jdo.datanucleus.CreateSchemaObjectFromClassMetadata;
import org.apache.isis.objectstore.jdo.datanucleus.DataNucleusApplicationComponents;
import org.apache.isis.objectstore.jdo.datanucleus.DataNucleusObjectStore;
import org.apache.isis.objectstore.jdo.datanucleus.JDOStateManagerForIsis;
import org.apache.isis.objectstore.jdo.metamodel.facets.object.auditable.AuditableAnnotationInJdoApplibFacetFactory;
import org.apache.isis.objectstore.jdo.metamodel.facets.object.auditable.AuditableMarkerInterfaceInJdoApplibFacetFactory;
import org.apache.isis.objectstore.jdo.metamodel.facets.object.datastoreidentity.JdoDatastoreIdentityAnnotationFacetFactory;
import org.apache.isis.objectstore.jdo.metamodel.facets.object.discriminator.JdoDiscriminatorAnnotationFacetFactory;
import org.apache.isis.objectstore.jdo.metamodel.facets.object.embeddedonly.JdoEmbeddedOnlyAnnotationFacetFactory;
import org.apache.isis.objectstore.jdo.metamodel.facets.object.persistencecapable.JdoPersistenceCapableAnnotationFacetFactory;
import org.apache.isis.objectstore.jdo.metamodel.facets.object.query.JdoQueryAnnotationFacetFactory;
import org.apache.isis.objectstore.jdo.metamodel.facets.object.version.JdoVersionAnnotationFacetFactory;
import org.apache.isis.objectstore.jdo.metamodel.facets.prop.column.BigDecimalDerivedFromJdoColumnAnnotationFacetFactory;
import org.apache.isis.objectstore.jdo.metamodel.facets.prop.column.MandatoryFromJdoColumnAnnotationFacetFactory;
import org.apache.isis.objectstore.jdo.metamodel.facets.prop.column.MaxLengthDerivedFromJdoColumnAnnotationFacetFactory;
import org.apache.isis.objectstore.jdo.metamodel.facets.prop.notpersistent.JdoNotPersistentAnnotationFacetFactory;
import org.apache.isis.objectstore.jdo.metamodel.facets.prop.primarykey.JdoPrimaryKeyAnnotationFacetFactory;
import org.apache.isis.objectstore.jdo.metamodel.specloader.validator.JdoMetaModelValidator;
import org.apache.isis.objectstore.jdo.service.RegisterEntities;
import org.datanucleus.api.jdo.JDOPersistenceManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataNucleusPersistenceMechanismInstaller
extends InstallerAbstract
implements PersistenceMechanismInstaller {
    private static final Logger LOG = LoggerFactory.getLogger(DataNucleusPersistenceMechanismInstaller.class);
    public static final String NAME = "datanucleus";
    public static final String CLASS_METADATA_LOADED_LISTENER_KEY = "classMetadataLoadedListener";
    static final String CLASS_METADATA_LOADED_LISTENER_DEFAULT = CreateSchemaObjectFromClassMetadata.class.getName();
    private static final String JDO_OBJECTSTORE_CONFIG_PREFIX = "isis.persistor.datanucleus";
    private static final String DATANUCLEUS_CONFIG_PREFIX = "isis.persistor.datanucleus.impl";
    private DataNucleusApplicationComponents applicationComponents = null;

    public DataNucleusPersistenceMechanismInstaller() {
        super("persistor", NAME);
    }

    @Override
    public PersistenceSessionFactory createPersistenceSessionFactory(DeploymentType deploymentType, ServicesInjectorSpi servicesInjector, IsisConfiguration configuration, RuntimeContextFromSession runtimeContext) {
        DataNucleusPersistenceMechanismInstaller objectStoreFactory = this;
        return new PersistenceSessionFactory(deploymentType, servicesInjector, configuration, objectStoreFactory, runtimeContext);
    }

    @Override
    public ObjectStore createObjectStore(IsisConfiguration configuration) {
        DataNucleusApplicationComponents applicationComponents = this.createDataNucleusApplicationComponentsIfRequired(configuration);
        return new DataNucleusObjectStore(applicationComponents);
    }

    private DataNucleusApplicationComponents createDataNucleusApplicationComponentsIfRequired(IsisConfiguration configuration) {
        if (this.applicationComponents == null || this.applicationComponents.isStale()) {
            IsisConfiguration jdoObjectstoreConfig = configuration.createSubset(JDO_OBJECTSTORE_CONFIG_PREFIX);
            IsisConfiguration dataNucleusConfig = configuration.createSubset(DATANUCLEUS_CONFIG_PREFIX);
            Map datanucleusProps = dataNucleusConfig.asMap();
            DataNucleusPersistenceMechanismInstaller.addDataNucleusPropertiesIfRequired(datanucleusProps);
            RegisterEntities registerEntities = new RegisterEntities(configuration.asMap());
            Set<String> classesToBePersisted = registerEntities.getEntityTypes();
            this.applicationComponents = new DataNucleusApplicationComponents(jdoObjectstoreConfig, datanucleusProps, classesToBePersisted);
        }
        return this.applicationComponents;
    }

    private static void addDataNucleusPropertiesIfRequired(Map<String, String> props) {
        DataNucleusPersistenceMechanismInstaller.putIfNotPresent(props, "datanucleus.objectProvider.className", JDOStateManagerForIsis.class.getName());
        DataNucleusPersistenceMechanismInstaller.putIfNotPresent(props, "javax.jdo.PersistenceManagerFactoryClass", JDOPersistenceManagerFactory.class.getName());
        DataNucleusPersistenceMechanismInstaller.putIfNotPresent(props, "datanucleus.schema.autoCreateSchema", Boolean.FALSE.toString());
        DataNucleusPersistenceMechanismInstaller.putIfNotPresent(props, "datanucleus.schema.validateAll", Boolean.TRUE.toString());
        DataNucleusPersistenceMechanismInstaller.putIfNotPresent(props, "datanucleus.cache.level2.type", "none");
        DataNucleusPersistenceMechanismInstaller.putIfNotPresent(props, "datanucleus.persistenceUnitLoadClasses", Boolean.TRUE.toString());
        String connectionFactoryName = props.get("datanucleus.ConnectionFactoryName");
        if (connectionFactoryName != null) {
            String connectionFactory2Name = props.get("datanucleus.ConnectionFactory2Name");
            String transactionType = props.get("javax.jdo.option.TransactionType");
            if (transactionType == null) {
                LOG.info("found non-JTA JNDI datasource (" + connectionFactoryName + ")");
                if (connectionFactory2Name != null) {
                    LOG.warn("found non-JTA JNDI datasource (" + connectionFactoryName + "); second '-nontx' JNDI datasource configured but will not be used (" + connectionFactory2Name + ")");
                }
            } else {
                LOG.info("found JTA JNDI datasource (" + connectionFactoryName + ")");
            }
            if (connectionFactory2Name == null) {
                LOG.error("found JTA JNDI datasource (" + connectionFactoryName + ") but second '-nontx' JNDI datasource *not* found");
            } else {
                LOG.info("... and second '-nontx' JNDI datasource found; " + connectionFactory2Name);
            }
            return;
        }
        LOG.info("did *not* find JNDI datasource; will use JDBC");
        DataNucleusPersistenceMechanismInstaller.putIfNotPresent(props, "javax.jdo.option.ConnectionDriverName", "org.hsqldb.jdbcDriver");
        DataNucleusPersistenceMechanismInstaller.putIfNotPresent(props, "javax.jdo.option.ConnectionURL", "jdbc:hsqldb:mem:test");
        DataNucleusPersistenceMechanismInstaller.putIfNotPresent(props, "javax.jdo.option.ConnectionUserName", "sa");
        DataNucleusPersistenceMechanismInstaller.putIfNotPresent(props, "javax.jdo.option.ConnectionPassword", "");
    }

    private static void putIfNotPresent(Map<String, String> props, String key, String value) {
        if (!props.containsKey(key)) {
            props.put(key, value);
        }
    }

    public void refineProgrammingModel(ProgrammingModel programmingModel, IsisConfiguration configuration) {
        programmingModel.addFactory(JdoPersistenceCapableAnnotationFacetFactory.class, ProgrammingModel.Position.BEGINNING);
        programmingModel.addFactory(JdoDatastoreIdentityAnnotationFacetFactory.class);
        programmingModel.addFactory(JdoEmbeddedOnlyAnnotationFacetFactory.class);
        programmingModel.addFactory(JdoPrimaryKeyAnnotationFacetFactory.class);
        programmingModel.addFactory(JdoNotPersistentAnnotationFacetFactory.class);
        programmingModel.addFactory(JdoDiscriminatorAnnotationFacetFactory.class);
        programmingModel.addFactory(JdoVersionAnnotationFacetFactory.class);
        programmingModel.addFactory(JdoQueryAnnotationFacetFactory.class);
        programmingModel.addFactory(BigDecimalDerivedFromJdoColumnAnnotationFacetFactory.class);
        programmingModel.addFactory(MaxLengthDerivedFromJdoColumnAnnotationFacetFactory.class);
        programmingModel.addFactory(MandatoryFromJdoColumnAnnotationFacetFactory.class);
        programmingModel.addFactory(AuditableAnnotationInJdoApplibFacetFactory.class);
        programmingModel.addFactory(AuditableMarkerInterfaceInJdoApplibFacetFactory.class);
    }

    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator, IsisConfiguration configuration) {
        metaModelValidator.add((MetaModelValidator)new JdoMetaModelValidator());
    }

    protected SpecificationLoaderSpi getSpecificationLoader() {
        return IsisContext.getSpecificationLoader();
    }

    public List<Class<?>> getTypes() {
        return DataNucleusPersistenceMechanismInstaller.listOf((Class[])new Class[]{PersistenceSessionFactory.class});
    }
}

