/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.datanucleus;

import com.google.common.base.Joiner;
import org.apache.isis.core.commons.config.IsisConfigurationDefault;
import org.apache.isis.core.commons.resource.ResourceStreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsisConfigurationForJdoIntegTests
extends IsisConfigurationDefault {
    private static final Logger LOG = LoggerFactory.getLogger(IsisConfigurationForJdoIntegTests.class);

    public IsisConfigurationForJdoIntegTests() {
        this(null);
    }

    public IsisConfigurationForJdoIntegTests(ResourceStreamSource resourceStreamSource) {
        super(resourceStreamSource);
        this.addStandardProperties();
    }

    private void addStandardProperties() {
        this.addDataNucleusProperty("javax.jdo.option.ConnectionURL", "jdbc:hsqldb:mem:test");
        this.addDataNucleusProperty("javax.jdo.option.ConnectionDriverName", "org.hsqldb.jdbcDriver");
        this.addDataNucleusProperty("javax.jdo.option.ConnectionUserName", "sa");
        this.addDataNucleusProperty("javax.jdo.option.ConnectionPassword", "");
        this.addDataNucleusProperty("datanucleus.schema.autoCreateAll", "true");
        this.addDataNucleusProperty("datanucleus.schema.validateAll", "false");
        this.addDataNucleusProperty("datanucleus.persistenceByReachabilityAtCommit", "false");
        this.addDataNucleusProperty("datanucleus.identifier.case", "MixedCase");
        this.addDataNucleusProperty("datanucleus.cache.level2.type", "none");
        this.addDataNucleusProperty("datanucleus.cache.level2.mode", "ENABLE_SELECTIVE");
        this.add("isis.persistor.datanucleus.install-fixtures", "true");
        this.add("isis.persistor.enforceSafeSemantics", "false");
        this.add("isis.deploymentType", "server_prototype");
        this.add("isis.services.eventbus.allowLateRegistration", "true");
    }

    public final IsisConfigurationForJdoIntegTests addDataNucleusProperty(String key, String value) {
        this.add("isis.persistor.datanucleus.impl." + key, value);
        return this;
    }

    public final IsisConfigurationForJdoIntegTests putDataNucleusProperty(String key, String value) {
        this.put("isis.persistor.datanucleus.impl." + key, value);
        return this;
    }

    public final IsisConfigurationForJdoIntegTests addRegisterEntitiesPackagePrefix(String ... packagePrefix) {
        String commaSeparated = Joiner.on((char)',').join((Object[])packagePrefix);
        this.add("isis.persistor.datanucleus.RegisterEntities.packagePrefix", commaSeparated);
        return this;
    }

    public final IsisConfigurationForJdoIntegTests putRegisterEntitiesPackagePrefix(String ... packagePrefix) {
        String commaSeparated = Joiner.on((char)',').join((Object[])packagePrefix);
        this.put("isis.persistor.datanucleus.RegisterEntities.packagePrefix", commaSeparated);
        return this;
    }
}

