/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.datanucleus.persistence;

import java.text.MessageFormat;
import java.util.concurrent.Callable;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ResolveState;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.adapter.version.ConcurrencyException;
import org.apache.isis.core.metamodel.adapter.version.Version;
import org.apache.isis.core.metamodel.facets.object.callbacks.CallbackFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.LoadedCallbackFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.PersistedCallbackFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.PersistingCallbackFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.RemovingCallbackFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.UpdatedCallbackFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.UpdatingCallbackFacet;
import org.apache.isis.core.runtime.persistence.PersistorUtil;
import org.apache.isis.core.runtime.persistence.adaptermanager.AdapterManagerDefault;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.OidGenerator;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.transaction.IsisTransaction;
import org.apache.isis.objectstore.jdo.datanucleus.DataNucleusObjectStore;
import org.apache.isis.objectstore.jdo.datanucleus.persistence.LoggingLocation;
import org.apache.isis.objectstore.jdo.datanucleus.persistence.Utils;
import org.datanucleus.enhancement.Persistable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrameworkSynchronizer {
    private static final Logger LOG = LoggerFactory.getLogger(FrameworkSynchronizer.class);

    public void postLoadProcessingFor(final Persistable pojo, CalledFrom calledFrom) {
        this.withLogging(pojo, new Runnable(){

            @Override
            public void run() {
                Persistable pc = pojo;
                FrameworkSynchronizer.this.getPersistenceSession().getServicesInjector().injectServicesInto((Object)pojo);
                Version datastoreVersion = FrameworkSynchronizer.this.getVersionIfAny(pc);
                ObjectAdapter adapter = FrameworkSynchronizer.this.getAdapterManager().getAdapterFor(pojo);
                if (adapter != null) {
                    FrameworkSynchronizer.this.ensureRootObject(pojo);
                    RootOid originalOid = (RootOid)adapter.getOid();
                    Version originalVersion = adapter.getVersion();
                    FrameworkSynchronizer.this.getPersistenceSession().getAdapterManager().remapRecreatedPojo(adapter, pojo);
                    RootOid thisOid = originalOid;
                    Version thisVersion = originalVersion;
                    Version otherVersion = datastoreVersion;
                    if (thisVersion != null && otherVersion != null && thisVersion.different(otherVersion)) {
                        if (AdapterManager.ConcurrencyChecking.isCurrentlyEnabled()) {
                            LOG.info("concurrency conflict detected on " + thisOid + " (" + otherVersion + ")");
                            String currentUser = FrameworkSynchronizer.this.getAuthenticationSession().getUserName();
                            ConcurrencyException abortCause = new ConcurrencyException(currentUser, (Oid)thisOid, thisVersion, otherVersion);
                            FrameworkSynchronizer.this.getCurrentTransaction().setAbortCause((IsisException)abortCause);
                        } else {
                            LOG.warn("concurrency conflict detected but suppressed, on " + thisOid + " (" + otherVersion + ")");
                        }
                    }
                } else {
                    OidGenerator oidGenerator = FrameworkSynchronizer.this.getOidGenerator();
                    RootOid originalOid = oidGenerator.createPersistentOrViewModelOid(pojo, null);
                    adapter = FrameworkSynchronizer.this.getAdapterManager().getAdapterFor((Oid)originalOid);
                    if (adapter != null) {
                        FrameworkSynchronizer.this.getPersistenceSession().getAdapterManager().remapRecreatedPojo(adapter, pojo);
                    } else {
                        adapter = FrameworkSynchronizer.this.getPersistenceSession().getAdapterManager().mapRecreatedPojo((Oid)originalOid, pojo);
                        CallbackFacet.Util.callCallback((ObjectAdapter)adapter, LoadedCallbackFacet.class);
                    }
                }
                if (!adapter.isResolved() && !adapter.isDestroyed()) {
                    PersistorUtil.startResolving(adapter);
                    PersistorUtil.toEndState(adapter);
                }
                adapter.setVersion(datastoreVersion);
                if (pojo.dnIsDeleted() && !adapter.isDestroyed()) {
                    adapter.changeState(ResolveState.DESTROYED);
                }
                FrameworkSynchronizer.this.ensureFrameworksInAgreement(pojo);
            }
        }, calledFrom);
    }

    public void preStoreProcessingFor(final Persistable pojo, CalledFrom calledFrom) {
        this.withLogging(pojo, new Runnable(){

            @Override
            public void run() {
                ObjectAdapter adapter = FrameworkSynchronizer.this.getAdapterManager().getAdapterFor(pojo);
                if (adapter == null) {
                    return;
                }
                RootOid isisOid = (RootOid)adapter.getOid();
                if (isisOid.isTransient()) {
                    CallbackFacet.Util.callCallback((ObjectAdapter)adapter, PersistingCallbackFacet.class);
                }
            }
        }, calledFrom);
    }

    public void postStoreProcessingFor(final Persistable pojo, CalledFrom calledFrom) {
        this.withLogging(pojo, new Runnable(){

            @Override
            public void run() {
                FrameworkSynchronizer.this.ensureRootObject(pojo);
                if (!pojo.dnIsPersistent()) {
                    throw new IllegalStateException("Pojo JDO state is not persistent! pojo dnOid: " + JDOHelper.getObjectId((Object)pojo));
                }
                ObjectAdapter adapter = FrameworkSynchronizer.this.getAdapterManager().getAdapterFor(pojo);
                RootOid isisOid = (RootOid)adapter.getOid();
                if (isisOid.isTransient()) {
                    RootOid persistentOid = FrameworkSynchronizer.this.getOidGenerator().createPersistentOrViewModelOid(pojo, isisOid);
                    FrameworkSynchronizer.this.getPersistenceSession().getAdapterManager().remapAsPersistent(adapter, persistentOid);
                    CallbackFacet.Util.callCallback((ObjectAdapter)adapter, PersistedCallbackFacet.class);
                    IsisTransaction transaction = FrameworkSynchronizer.this.getCurrentTransaction();
                    transaction.enlistCreated(adapter);
                } else {
                    CallbackFacet.Util.callCallback((ObjectAdapter)adapter, UpdatedCallbackFacet.class);
                }
                Utils.clearDirtyFor(adapter);
                Version versionIfAny = FrameworkSynchronizer.this.getVersionIfAny(pojo);
                adapter.setVersion(versionIfAny);
                FrameworkSynchronizer.this.ensureFrameworksInAgreement(pojo);
            }
        }, calledFrom);
    }

    public void preDirtyProcessingFor(final Persistable pojo, CalledFrom calledFrom) {
        this.withLogging(pojo, new Runnable(){

            @Override
            public void run() {
                ObjectAdapter adapter = FrameworkSynchronizer.this.getAdapterManager().getAdapterFor(pojo);
                if (adapter == null && (adapter = FrameworkSynchronizer.this.lazilyLoaded(pojo, CalledFrom.EVENT_PREDIRTY)) == null) {
                    throw new RuntimeException("DN could not find objectId for pojo (unexpected) and so could not map into Isis; pojo=[" + pojo + "]");
                }
                if (adapter.isTransient()) {
                    return;
                }
                CallbackFacet.Util.callCallback((ObjectAdapter)adapter, UpdatingCallbackFacet.class);
                IsisTransaction transaction = FrameworkSynchronizer.this.getCurrentTransaction();
                transaction.enlistUpdating(adapter);
                FrameworkSynchronizer.this.ensureRootObject(pojo);
                FrameworkSynchronizer.this.ensureFrameworksInAgreement(pojo);
            }
        }, calledFrom);
    }

    public ObjectAdapter lazilyLoaded(final Persistable pojo, CalledFrom calledFrom) {
        return this.withLogging(pojo, new Callable<ObjectAdapter>(){

            @Override
            public ObjectAdapter call() {
                if (FrameworkSynchronizer.this.getJdoPersistenceManager().getObjectId((Object)pojo) == null) {
                    return null;
                }
                RootOid oid = FrameworkSynchronizer.this.getPersistenceSession().getOidGenerator().createPersistentOrViewModelOid(pojo, null);
                ObjectAdapter adapter = FrameworkSynchronizer.this.getPersistenceSession().getAdapterManager().mapRecreatedPojo((Oid)oid, pojo);
                return adapter;
            }
        }, calledFrom);
    }

    public void preDeleteProcessingFor(final Persistable pojo, CalledFrom calledFrom) {
        this.withLogging(pojo, new Runnable(){

            @Override
            public void run() {
                ObjectAdapter adapter = FrameworkSynchronizer.this.getAdapterManager().adapterFor(pojo);
                IsisTransaction transaction = FrameworkSynchronizer.this.getCurrentTransaction();
                transaction.enlistDeleting(adapter);
                CallbackFacet.Util.callCallback((ObjectAdapter)adapter, RemovingCallbackFacet.class);
                FrameworkSynchronizer.this.ensureFrameworksInAgreement(pojo);
            }
        }, calledFrom);
    }

    public void postDeleteProcessingFor(final Persistable pojo, CalledFrom calledFrom) {
        this.withLogging(pojo, new Runnable(){

            @Override
            public void run() {
                ObjectAdapter adapter = FrameworkSynchronizer.this.getAdapterManager().getAdapterFor(pojo);
                if (adapter == null) {
                    return;
                }
                if (!adapter.isDestroyed()) {
                    adapter.changeState(ResolveState.DESTROYED);
                }
                FrameworkSynchronizer.this.ensureFrameworksInAgreement(pojo);
            }
        }, calledFrom);
    }

    private <T> T withLogging(Persistable pojo, Callable<T> runnable, CalledFrom calledFrom) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.logString(calledFrom, LoggingLocation.ENTRY, pojo));
        }
        try {
            T t = runnable.call();
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.logString(calledFrom, LoggingLocation.EXIT, pojo));
            }
        }
    }

    private void withLogging(Persistable pojo, final Runnable runnable, CalledFrom calledFrom) {
        this.withLogging(pojo, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                runnable.run();
                return null;
            }
        }, calledFrom);
    }

    private String logString(CalledFrom calledFrom, LoggingLocation location, Persistable pojo) {
        AdapterManagerDefault adapterManager = this.getAdapterManager();
        ObjectAdapter adapter = adapterManager.getAdapterFor(pojo);
        return calledFrom.name() + " " + location.prefix + " oid=" + (adapter != null ? adapter.getOid() : "(null)") + " ,pojo " + pojo;
    }

    void ensureFrameworksInAgreement(Persistable pojo) {
        ObjectAdapter adapter = this.getAdapterManager().getAdapterFor(pojo);
        Oid oid = adapter.getOid();
        if (!pojo.dnIsPersistent()) {
            if (!adapter.getResolveState().isTransient()) {
                throw new IsisException(MessageFormat.format("adapter oid={0} has resolve state in invalid state; should be transient but is {1}; pojo: {2}", oid, adapter.getResolveState(), pojo));
            }
            if (!oid.isTransient()) {
                throw new IsisException(MessageFormat.format("adapter oid={0} has oid in invalid state; should be transient; pojo: {1}", oid, pojo));
            }
        } else if (pojo.dnIsDeleted()) {
            if (!adapter.getResolveState().isDestroyed()) {
                throw new IsisException(MessageFormat.format("adapter oid={0} has resolve state in invalid state; should be destroyed but is {1}; pojo: {2}", oid, adapter.getResolveState(), pojo));
            }
        } else {
            if (!adapter.getResolveState().representsPersistent()) {
                throw new IsisException(MessageFormat.format("adapter oid={0} has resolve state in invalid state; should be in a persistent but is {1}; pojo: {2}", oid, adapter.getResolveState(), pojo));
            }
            if (oid.isTransient()) {
                throw new IsisException(MessageFormat.format("adapter oid={0} has oid in invalid state; should be persistent; pojo: {1}", oid, pojo));
            }
        }
    }

    void ensureRootObject(Persistable pojo) {
        Oid oid = this.getAdapterManager().adapterFor(pojo).getOid();
        if (!(oid instanceof RootOid)) {
            throw new IsisException(MessageFormat.format("Not a RootOid: oid={0}, for {1}", oid, pojo));
        }
    }

    private Version getVersionIfAny(Persistable pojo) {
        return Utils.getVersionIfAny(pojo, this.getAuthenticationSession());
    }

    private void ensureObjectNotLoaded(Persistable pojo) {
        ObjectAdapter adapter = this.getAdapterManager().getAdapterFor(pojo);
        if (adapter != null) {
            Oid oid = adapter.getOid();
            throw new IsisException(MessageFormat.format("Object is already mapped in Isis: oid={0}, for {1}", oid, pojo));
        }
    }

    protected AdapterManagerDefault getAdapterManager() {
        return this.getPersistenceSession().getAdapterManager();
    }

    protected OidGenerator getOidGenerator() {
        return this.getPersistenceSession().getOidGenerator();
    }

    protected PersistenceSession getPersistenceSession() {
        return IsisContext.getPersistenceSession();
    }

    protected AuthenticationSession getAuthenticationSession() {
        return IsisContext.getAuthenticationSession();
    }

    protected IsisTransaction getCurrentTransaction() {
        return IsisContext.getCurrentTransaction();
    }

    protected PersistenceManager getJdoPersistenceManager() {
        DataNucleusObjectStore objectStore = this.getObjectStore();
        return objectStore.getPersistenceManager();
    }

    protected DataNucleusObjectStore getObjectStore() {
        return (DataNucleusObjectStore)IsisContext.getPersistenceSession().getObjectStore();
    }

    public static enum CalledFrom {
        EVENT_LOAD,
        EVENT_PRESTORE,
        EVENT_POSTSTORE,
        EVENT_PREDIRTY,
        EVENT_POSTDIRTY,
        OS_QUERY,
        OS_RESOLVE,
        OS_LAZILYLOADED,
        EVENT_PREDELETE,
        EVENT_POSTDELETE;

    }
}

