/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.datanucleus.valuetypes;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.isis.applib.value.Clob;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.ExecutionContext;
import org.datanucleus.NucleusContext;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.java.SingleFieldMultiMapping;
import org.datanucleus.store.rdbms.table.Table;

public class IsisClobMapping
extends SingleFieldMultiMapping {
    public Class<?> getJavaType() {
        return Clob.class;
    }

    public void initialize(AbstractMemberMetaData mmd, Table container, ClassLoaderResolver clr) {
        super.initialize(mmd, container, clr);
        this.addColumns();
    }

    public void initialize(RDBMSStoreManager storeMgr, String type) {
        super.initialize(storeMgr, type);
        this.addColumns();
    }

    protected void addColumns() {
        this.addColumns(ClassNameConstants.JAVA_LANG_STRING);
        this.addColumns(ClassNameConstants.JAVA_LANG_STRING);
        this.addColumns(ClassNameConstants.JAVA_LANG_STRING);
    }

    public Object getValueForDatastoreMapping(NucleusContext nucleusCtx, int index, Object value) {
        Clob clob = (Clob)value;
        switch (index) {
            case 0: {
                return clob.getName();
            }
            case 1: {
                return clob.getMimeType().getBaseType();
            }
            case 2: {
                return clob.getChars();
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public void setObject(ExecutionContext ec, PreparedStatement preparedStmt, int[] exprIndex, Object value) {
        Clob clob = (Clob)value;
        if (clob == null) {
            this.getDatastoreMapping(0).setObject(preparedStmt, exprIndex[0], null);
            this.getDatastoreMapping(1).setObject(preparedStmt, exprIndex[1], null);
            this.getDatastoreMapping(2).setObject(preparedStmt, exprIndex[2], null);
        } else {
            this.getDatastoreMapping(0).setString(preparedStmt, exprIndex[0], clob.getName());
            this.getDatastoreMapping(1).setString(preparedStmt, exprIndex[1], clob.getMimeType().getBaseType());
            this.getDatastoreMapping(2).setObject(preparedStmt, exprIndex[2], (Object)clob.getChars().toString());
        }
    }

    public Object getObject(ExecutionContext ec, ResultSet resultSet, int[] exprIndex) {
        try {
            if (this.getDatastoreMapping(0).getObject(resultSet, exprIndex[0]) == null) {
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String name = this.getDatastoreMapping(0).getString(resultSet, exprIndex[0]);
        String mimeTypeBase = this.getDatastoreMapping(1).getString(resultSet, exprIndex[1]);
        String str = this.getDatastoreMapping(2).getString(resultSet, exprIndex[2]);
        if (name == null || mimeTypeBase == null || str == null) {
            return null;
        }
        return new Clob(name, mimeTypeBase, str.toCharArray());
    }
}

