/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.security.shiro.permrolemapper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.apache.isis.security.shiro.permrolemapper.PermissionToRoleMapper;
import org.apache.shiro.config.Ini;
import org.apache.shiro.util.PermissionUtils;

public class PermissionToRoleMapperFromIni
implements PermissionToRoleMapper {
    private final Map<String, List<String>> permissionsByRole;

    public PermissionToRoleMapperFromIni(Ini ini) {
        Ini.Section section = ini.getSection("roles");
        this.permissionsByRole = Maps.transformEntries((Map)section, (Maps.EntryTransformer)new Maps.EntryTransformer<String, String, List<String>>(){

            public List<String> transformEntry(String key, String value) {
                return Lists.newArrayList((Iterable)PermissionUtils.toPermissionStrings((String)value));
            }
        });
    }

    @Override
    public Map<String, List<String>> getPermissionsByRole() {
        return this.permissionsByRole;
    }
}

