/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.unittestsupport;

import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import javax.jdo.annotations.PersistenceCapable;
import org.apache.isis.core.unittestsupport.utils.IndentPrinter;
import org.junit.Test;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public abstract class AbstractApplyToAllContractTest {
    protected final Reflections reflections;
    protected IndentPrinter out;

    protected AbstractApplyToAllContractTest(String packagePrefix) {
        this.reflections = new Reflections(packagePrefix, new Scanner[0]);
        this.out = new IndentPrinter(new PrintWriter(ByteStreams.nullOutputStream()));
    }

    public AbstractApplyToAllContractTest withLoggingTo(Writer out) {
        this.out = new IndentPrinter(out);
        return this;
    }

    public AbstractApplyToAllContractTest withLoggingTo(PrintStream out) {
        this.out = new IndentPrinter(new PrintWriter(out));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void searchAndTest() throws Exception {
        TreeSet entityTypes = Sets.newTreeSet((Comparator)new Comparator<Class<?>>(){

            @Override
            public int compare(Class<?> o1, Class<?> o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        entityTypes.addAll(this.findTypes());
        for (Class entityType : entityTypes) {
            this.out.println(entityType.getName());
            this.out.incrementIndent();
            try {
                this.applyContractTest(entityType);
            }
            finally {
                this.out.decrementIndent();
            }
        }
        this.out.println("DONE");
    }

    protected Set<Class<?>> findTypes() {
        return this.reflections.getTypesAnnotatedWith(PersistenceCapable.class);
    }

    protected abstract void applyContractTest(Class<?> var1);
}

